                	INCLUDE "code/macro.asm"  ;ALIGN macro definition
			INCLUDE	"code/struct.asm" ;Data structures for cars and cameras
			INCLUDE "data/charset.asm";Character encoding labels for messages
			
			INCLUDE "labels6.asm"	;Labels for memory page 6 (128k players)

thebigbuffer		EQU	32768		;768 bytes start buffer, aligned to a 256-byte boundary
exo_mapbasebits 	EQU	32768		;exomizer 2 buffer, the same one
mapa			EQU	37632		;map buffer, also used to uncompress wyzplayer music and more
lotsofldis		EQU	mapa+3072	;
mapa_tablecolors	EQU	mapa+3072+512+2
keyreadbuffer		EQU	mapa+3072+520	
theredefkey		EQU	mapa+3072+540	;Store read keys while redefining
mapa_checks		EQU	mapa+4096

			ORG	24573	;Aligned to 256 (-3 for jump)
					;leaves 253 bytes for stack
aborted:		JP	PRE_START	;Start (was there for .tap version, now unused). Now also holds the "aborted" variable.

ALIGN 1024

charset:		INCBIN  "bindata/ins_charset.bin"	;Charset, aligned to 1024
			INCBIN  "bindata/extrachars.bin"	;Extra chars
marcador:		INCBIN  "bindata/marca.exp"		;Markers screen
menulogo:		INCBIN	"bindata/menu.exp"		;Black screen with logo
classification:		INCBIN	"bindata/class.exp"		;Black screen with green center for interlude
mapa02:			INCBIN	"bindata/fase02.exp"		;Stage 2
mapa03:			INCBIN	"bindata/fase03.exp"		;Stage 3
mapa04:			INCBIN	"bindata/fase04.exp"		;Stage 4
mapa05:			INCBIN	"bindata/fase05.exp"		;Stage 5
mapa06:			INCBIN	"bindata/fase06.exp"		;Stage 6
mapa07:			INCBIN	"bindata/fase07.exp"		;Stage 7
mapa08:			INCBIN	"bindata/fase08.exp"		;Stage 8
			INCLUDE "data/spd_table.asm"		;Speeds table

;*********
;setbank0: sets the default bank (0).
;*********
setbank0:		xor	a			;A = 0, continue to next function

;********
;setbank: Sets the bank specified in A in the last page.
;********
setbank:		push	bc
			ld	bc,32765		;Write Port
     			ld	(lastbank),a		;Last used bank
setbank_high:		or	0			;Insert here high bits
     			out	(c),a			;Direccionar
     			pop	bc
			ret

;************
;putmapsdown: prints the micro maps at the lower part of the screen, used in both the Records screen during menu, and the personalization menu.
;************
putmapsdown:		xor	a		;Start with map 0
			ld	de,20608	;Starting position
pmd_loop:		push	af
			push	de
			call	printmicromap	;Print micromap
			pop	de
			ld	a,4
			add	a,e
			ld	e,a		;Update position for next micromap
			pop	af
			inc	a		;Next map
			cp	8
			jr	nz,pmd_loop	;Loop if we haven't reached 8
			ret
lastmap:
			ORG	33280

;**********
;PRE_START: Will be executed only at the beginning, then erased since it's placed inside the big CezBlocks buffer
;**********
PRE_START:		di				;Disable interrupts
			ld	hl,inttable			
			ld	de,inttable+1
			ld	bc,256
			ld	a,133
			ld	(hl),a
			ldir				;Fill 257 bytes interrupt table
			
			ld 	a, (#5B5C)   		; at 5B5C there's the current page
			and 	248			;Isolate high bits
			ld	(setbank_high+1),a	;Set them at pagination routine
			ld	a,1
	        	call	setbank			;Set page 1
			xor	a
			out	(254),a			;Black border
			ld	(is128k),a		;Is128k to 0 if we're in a 48k model
        		call	setbank0		;Set page 0 again
        		ld	a,(is128k)		;If there was no pagination (48k), we'll read 0, if there was
        						; pagination (128k), it will read 1
			and	a			;
			ld	(recording),a		;Set recording variable
			jr	z,prestart_48

			xor	a
			ld	(menu+1),a			;In 128k, enable 128k menu initialization
			ld	(orfeus_reentry+1),a		;Disable Orfeus reentry
			ld	(main_currentsoundpatch),a	;And change sound 1 by 1, not 2 by 2 (to cycle 6 states
								;  in 128k, and only 3 in 48k)
prestart_48:		ld	a,132
			ld	i,a			;Set interrupt vector
			im	2
			ei				;Enable interrupts
			call	wait_key		;Wait key while showing the loading screen
			
			ld	hl,mapa			;The compressed logo lies here at the beginning
			call	deexo_screen		;Uncompress it to the screen
			ld	b,150			;Time counter

pausalogo:		ld	a,(key_g_a)		;Check if we're pressing the easter egg activating keys
			and	3			;Check AS
			jr	nz,noegg
			ld	a,(key_b_sp)
			and	4			;Check M
			jr	nz,noegg
			ld	a,b
			dec	a
			call	z,labelshere		;If we're pressing the activating keys when time is over, go to show it
noegg:			halt
			djnz	pausalogo		;Time passes

IF STEPN=2						;Conditional compilation, the first step has all labels in their places,
			ld	hl,labpacked		; while the second one has them packed in the buffer
ELSE
			ld	hl,0
ENDIF							;

			ld	de,labelshere		;
			call	deexo			;Unpack labels to their final place
			jp	menu			;And jump to menu
egg:			ret
			ORG	33536	;block 131


;**********
;check_key: check if there's any key pressed. Returns Z if no key is pressed, NZ if a key is pressed.
;**********
check_key:		xor	a
			in	a,(254)		;Read all keyboard.
			cpl
			and	31		;Mask significant bits, and excite flag Z.
			ret

;***********
;wait_nokey: wait until no key is being pressed
;***********
wait_nokey:		call	check_key
			jr	nz,wait_nokey
			ret
;************
;brujula_rut: returns the address of the compass character for the car pointed in IX
;************
brujula_rut:  		ld	l,(ix+SP_NEXTCHECK)
			ld	h,mapa_checks/256
			ld	a,(hl)
			inc	l
			add	a,(hl)
			rra			;get the middle point of both horizontal positions in checkpoints table

			sub	(ix+SP_MAPX)
			jr	z,bru_nohoriz	;0 for center
			jr	c,bru_noright
			cp	32
			jr	nc,bru_yesleft
bru_yesright:		ld	a,14		;14 for right
			jr	bru_nohoriz
bru_noright:		add	a,32
			jr	nc,bru_yesright
bru_yesleft:		ld	a,7		;7 for left
bru_nohoriz:		ld	e,a		;Keep value in E
			inc	l
			ld	a,(hl)
			inc	l
			add	a,(hl)
			rra			;get the middle point of both vertical positions in checkpoints table
			sub	(ix+SP_MAPY)
			jr	z,bru_novert	;0 for center
			jr	c,bru_nodown
			cp	32
			jr	nc,bru_yesup
bru_yesdown:		ld	a,42		;42 for down
			jr	bru_novert
bru_nodown:		add	a,32
			jr	nc,bru_yesdown
bru_yesup:		ld	a,21		;21 for up
bru_novert:		add	a,e		;Add horizontal value
			ld	l,a
			ld	h,0
			ld	de,brujula
			add	hl,de		;Add brujula offset
			ld	bc,8		;8 bytes counter
			ret
end_bru:


			ORG	33622
			INCLUDE "code/deexo.asm"	;Exomizer decompression routine
			ORG	33792			;block 132, here comes interrupt table
inttable:		
			ORG	34049

;******************
;menuprintcontrols: Prints the control option for each car
;******************
menuprintcontrols:	call	pmess_select_center	;Centered font
			ld	b,4
			ld	ix,car1			;Start with the first car
menpr_popti:		ld	c,b
			ld	a,4
menpr_posit:		sub	32
			dec	c
			jr	nz,menpr_posit
			push	bc
			ld	b,(ix+SP_CONTOPT)	;Get control option for the car
			ld	de,11
			ld	hl,mmenu_keys1-11	;First option address-11
			inc	b
menpr_getadd:		add	hl,de			;Next option address
			djnz	menpr_getadd
							;Here HL points to the option
			ld	b,h			
			ld	c,l			;BC = HL
			ld	d,64
			ld	e,a			;Address to print the option to
			call	printmessage		;Print car's control
			ld	bc,car2-car1
			add	ix,bc			;Next car
			pop	bc
			djnz	menpr_popti
			ld	bc,mmenu_fixed
			jr	printmessage		;Print fixed menu message, then exit

;*************
;printmessage: Prints the message pointed to by BC. DE holds the screen address to write to. The message format is explained in the messages.asm file.
;*************
pmess_attr:						;Value over 127, it's an attribute
			push	de			;Keep screen position
			sub	128			;Get attribute value
			ld	(pmess_attrloop-1),a	;Patch value into code
			ld	a,d
			rra
			rra
			rra
			or	80
			ld	d,a			;Get attribute address
			ld	a,(bc)			;Get number of characters
			inc	bc			;Increase pointer
			push	bc			;Keep BC for later
			ld	b,a			;Counter
			ld	a,0			;Load value
pmess_attrloop:		ld	(de),a			;Set attribute
			inc	de			;Next position
			djnz	pmess_attrloop		;Do loop
			pop	bc			;Restore message pointer
			pop	de			;Restore screen position
			jr	printmessage		;Keep printing

pmess_nochar:		cp	127			;Compare with 127
			ret	z			;value = 127: exit
			jr	nc,pmess_attr		
							;value under 127
			sub	32
			ld	d,a
			ld	a,(bc)
			inc	bc
			ld	e,a
printmessage:		ld	a,(bc)			;Get byte pointed by BC
			inc	bc			;Increase pointer
			cp	96			;under 96?
			jr	nc,pmess_nochar		;No:  No character
pmess_extrach:		ld	h,charset/1024		;Yes: Character
			push	bc
			push	de			;Keep BC and DE
			add	a,a
			ld	l,a
			add	hl,hl
			add	hl,hl			;HL=points to the character
pmess_rout:		call	putchar_down		;Print character
			pop	de
			pop	bc			;Restore BC and DE
			inc	e			;Increase printing position
			jr	printmessage		;Keep printing message.
before_interrupt:
			org	34181

;**********
;interrupt: interrupt routine, scans the keyboard and kempston joystick on every frame, keeping their states in variables, and then jumps to the address at interrupt_redir+1
;**********
interrupt:		push	af			;Store used registers
			push	bc
			in	a,(31)			;Read Kempston port
			cpl				;Reverse bits
			ld	(joy_kemp),a		;Store value
			ld	bc,65278		;Keyboard port for keys V-CS
                	in	a,(c)			;Read keys
			ld	(key_v_cs),a		;Store in variable
			dec	b			;Next port G-A
                	in	a,(c)			;Repeat for all keys
			ld	(key_g_a),a
			ld	b,251
                	in	a,(c)
			ld	(key_t_q),a
			ld	b,247
                	in	a,(c)
			ld	(key_5_1),a
			ld	b,239
                	in	a,(c)
			ld	(key_6_0),a
			ld	b,223
                	in	a,(c)
			ld	(key_y_p),a
			ld	b,191
                	in	a,(c)
			ld	(key_h_en),a
			ld	b,127
                	in	a,(c)
			ld	(key_b_sp),a
			pop	bc			;Restore BC
			ld	a,r			; mark bit 7 of R to signal the interrupt
			or	128
			ld	r,a
			pop	af			;Restore AF
interrupt_redir:	jp	int_end			;Exit or keep executing interrupt. This value will be patched to have different interrupt routines.
int_end:		ei				;Enable interrupts
			reti				;Exit from interrupt.


			INCLUDE "code/chars.asm"	;Character printing extra routines

;***********
;checkgrass: Check what lies ahead in a certain direction
;***********
checkgrass:		ld	a,(hl)		;Get vertical speed
			sra	a
			sra	a		;Divide by 4
			ld	e,a		;Keep vertical Displacement in register E
			ld	a,l
			sub	4
			ld	l,a		;HL=HL-4
			ld	a,(hl)		;Get horizontal speed
			sra	a
			sra	a		;Divide by 4
			ld	d,a		;Keep vertical Displacement in register D
			ld	a,l
			add	a,5		;HL=HL+5
			ld	l,a		;HL=speeds (current prefered direction+1)
			push	hl		;Keep HL
			ld	l,d		;Vertical Displacement in register L
			call	get_attr	;Get attribute
			pop	hl		;Restore HL
			and	56		;Isolate paper value
			cp	32		;Green?
			ret

;***********
;micropause: Do a 10 frames (0.2 seconds) pause
;***********
micropause:		push	bc
			ld	b,10
mpause:			halt			;Wait a vertical retraze
			djnz	mpause		;Repeat 10 times
			pop	bc
			ret

;********************
;minimap_draw_center: Draw the minimap at the center of the screen (for interlude)
;********************
minimap_draw_center:	ld	a,72			;Second third
			ld	(minimap_change1+1),a	;Patch first value
			ld	a,12			;At character 12
			jr	minimap_draw

;*****************
;minimap_draw_low:    Draw the minimap at the low part of the screen (starting the stage)
;*****************
minimap_draw_low:	ld	a,80			;Third third
			ld	(minimap_change1+1),a	;Patch first value
			ld	a,8			;At character 8
minimap_draw:		ld	(minimap_change2+1),a	;Patch second value
			ld	hl,mapa
			ld	de,0			;Minimap starting position
mmd_next:		ld	a,(hl)			;Read map
			and	63			;Remove limits bits
			cp	51			;Grass?
			push	de
			push	hl
			call	nz,minimap_xor		;Xor if there's no grass
			pop	hl
			pop	de
			inc	hl			;Next map location
			inc	d			;Increase minimap horizontal position
			ld	a,d
			cp	64
			jr	nz,mmd_next		;If we didn't reach 64, keep drawing
			ld	d,0			;Reset minimap horizontal position to 0
			inc	e			;Increase minimap vertical position
			ld	a,e
			cp	64
			jr	nz,mmd_next		;If we didn't reach 64, keep drawing
			ret

;************
;minimap_put: Place car in minimap
;************
minimap_put:		ld	e,(ix+SP_MAPY)		;Get current map coordinates for the car
			ld	d,(ix+SP_MAPX)
			ld	(ix+SP_MINIMAPY),e	;Store current map coordinates for the car
			ld	(ix+SP_MINIMAPX),d
			jr	minimap_xor		;Do a xor

;*************
;minimap_quit: Remove car from minimap
;*************
minimap_quit:		ld	e,(ix+SP_MINIMAPY)	;Get last coordinates used for the car in the map
			ld	d,(ix+SP_MINIMAPX)
							;Do a xor in the next routine

;************
;minimap_xor: Xor a bit in minimap, at position (D,E)
;************
minimap_xor:		call	minimap_addr		;Get address in HL, bit in A
			xor	(hl)			;Xor bit with (HL) contents
			ld	(hl),a			;Store result
			ret

;*************
;minimap_addr: Calculate the minimap address to be changed
;*************
minimap_addr:		ld	a,e			;e=mapy,d=mapx
			and	7			;A = 3 lower bits of vertical position
minimap_change1:	or	80
			ld	h,a
			ld	a,e
			rla
			rla
			and	224
			ld	l,a			;HL=mapy
			ld	e,0
			ld	a,d
			rra	
			rl	e
			rra	
			rl	e
			rra
			rl	e			;E = bits 00000_b0b1b2
minimap_change2:	add	a,8
			add	a,l
			ld	l,a			;HL=position of byte to be changed
			ld	a,minimap_bits-tilelist
			add	a,e
			ld	e,a
			ld	d,tilelist/256
			ld	a,(de)			;A = bit to change
			ret

;***************
;testlegal_chkz: Check how many car controls have a certain value
;***************
testlegal_chkz:		ld	l,0		;Counter to 0
			cp	b
			jr	nz,tl_nob
			inc	l		;Increase if car 1 has it
tl_nob:			cp	c
			jr	nz,tl_noc
			inc	l		;Increase if car 2 has it
tl_noc:			cp	d
			jr	nz,tl_nod
			inc	l		;Increase if car 3 has it
tl_nod:			cp	e
			ret	nz
			inc	l		;Increase if car 4 has it
			ret

;***************
;testlegal_chkc: Check how many car controls are below a certain value
;***************
testlegal_chkc:		ld	l,0		;Counter to 0
			cp	b
			jr	c,tl_nobc
			inc	l		;Increase if car 1 is below
tl_nobc:		cp	c
			jr	c,tl_nocc
			inc	l		;Increase if car 2 is below
tl_nocc:		cp	d
			jr	c,tl_nodc
			inc	l		;Increase if car 3 is below
tl_nodc:		cp	e
			ret	c
			inc	l		;Increase if car 4 is below
			ret

;********
;get1key: Get a key for redefinition
;********
redef_repeated:		pop	bc
			pop	hl			;Restore registers
			jr	redef_poll_pause	;Do a pause and start polling again

get1key:		exx				;Use alternate set of registers
redef_poll:		ld	b,8			;8 semi-rows
			ld	hl,key_v_cs		;Starting semirow
redef_byteloop:		ld	c,5			;5 keys
			ld	a,(hl)			;Get semirow
redef_bitloop:		rrca				;Get bit
			jr	nc,redef_keyfound	;If any bit is 0, a key has been pressed
			dec	c
			jr	nz,redef_bitloop	;Loop all 5 keys
			inc	hl			;Next semirow
			djnz	redef_byteloop		;Loop all 8 semirows
redef_poll_pause:	call	micropause_snd		;Do a small pause
			jr	redef_poll		;Keep polling keyboard

redef_keyfound:		push	hl			;Key found in BC
			push	bc			
			ld	a,c			;Get bit number
			add	a,a
			add	a,a
			add	a,a			;Multiply by 8
			add	a,b			;Add semirow, so A = key pressed
			ld	(theredefkey),a		;Keep it
			ld	b,a			;B = temporal key
			ld	a,(keysredefined)
			ld	c,a
			inc	c			;C = number of checks +1
			ld	a,b
			ld	b,0
			ld	hl,keyreadbuffer	;Buffer where read keys are stored
redef_checkrepeated:	cpi				;Compare with current key
			jp	po,redef_keyok
			jr	z,redef_repeated	;If the key is found, it means the key has already been used
			jr	redef_checkrepeated
redef_keyok:		dec	hl
			ld	(hl),a			;Store found key in the table.
			ld	hl,keysredefined
			inc	(hl)			;Increase the number of defined keys
			pop	bc			;B = semirow, C = key code
			pop	hl			;HL = semirow for the defined key
			ld	(iy+0),l		;First patch: variable read to get the semirow
			ld	(iy+1),h		;This can be removed if key_v_cs and key_b_sp share their high byte
			ld	a,32			;Bit position
redef_adjust:		rrca				;Move bit
			dec	c
			jr	nz,redef_adjust		;Do it C times
							;Now A holds the bit to be read
			ld	(iy+3),a		;Second patch: AND bit
			neg
			ld	(iy+5),a		;Third patch: ADD A,(256-bit)
			ld	a,(theredefkey)		;Get keycode
			add	a,(keytable%256)-9	;Get character for the keycode
			ld	l,a
			ld	h,keytable/256
			ld	a,(hl)			;Character in A
			ld	bc,ck1_left1-ck1_right1
			add	iy,bc			;Point to next key
			exx				;Restore original register set
			ret

;**************
;control_sinc1: Sinclair 1 control routine
;**************

control_sinc1:		ld	a,(key_6_0)
			rrca			;0
			rrca			;9
			rrca			;8
			rrca			;7 (keep)
			rl	e
			rrca			;6 (keep)
			rl	e
			rlca			;6
			rlca			;7
			rlca			;8
			rlca			;9 (keep)
			rl	e
			rrca			;9
			rrca			;8 (keep)
			rl	e
			ld	c,e
			and	32		;Fire?
                	ret	nz		;No: ret
                	res	1,c
                	ret
;**************
;control_sinc2: Sinclair 2 control routine
;**************
control_sinc2:		ld	a,(key_5_1)
			rrca			;1
			rrca			;2 (keep)
			rl	e
			rlca			;2
			rlca			;1 (keep)
			rl	e		
			rrca			;1
			rrca			;2
			rrca			;3
			rrca			;4 (keep)
control_kemp_sinc2:	rl	e
			rlca			;4 / U
			rlca			;3 / D (keep)
			rl	e
			ld	c,e
			and	4		;Fire?
                	ret	nz		;No: ret
                	res	1,c
                	ret

control_kemp:		ld	a,(joy_kemp)
			rrca			;R (guardar)
			rl	e
			rrca			;L (guardar)
			rl	e
			rrca			;D
			rrca			;U (guardar)
			jr	control_kemp_sinc2
;*************
;control_key1: Keyboard 1 control routine
;*************
control_key1:   	ld	c,0		;Starting value
ck1_right1:		ld      a,(key_y_p)	;First patch here: get semirow
ck1_right2:		and	1		;Second patch: isolate bit of the key we're interested on
ck1_right3:		add	a,255		;Third patch: If the bit is 1, carry flag will be excited. If the bit is 0, it won't
			ld	a,c
			adc	a,a		;Enter the carry bit into A
			ld	c,a
ck1_left1:		ld      a,(key_y_p)	;Repeat the same for all 4 keys...
ck1_left2:		and	2
ck1_left3:		add	a,254
			ld	a,c
			adc	a,a
			ld	c,a
ck1_up1:		ld      a,(key_t_q)
ck1_up2:		and	1
ck1_up3:		add	a,255
			ld	a,c
			adc	a,a
			ld	c,a
ck1_down1:		ld      a,(key_g_a)
ck1_down2:		and	1
ck1_down3:		add	a,255
			ld	a,c
			adc	a,a
			ld	c,a
                	ret			;C has the control value

;*************
;control_key2: Keyboard 2 control routine
;*************
control_key2:   	ld	c,0		;Same as control_key1
ck2_right1:		ld      a,(key_t_q)
ck2_right2:		and	8
ck2_right3:		add	a,248
			ld	a,c
			adc	a,a
			ld	c,a
ck2_left1:		ld      a,(key_t_q)
ck2_left2:		and	4
ck2_left3:		add	a,252
			ld	a,c
			adc	a,a
			ld	c,a
ck2_up1:		ld      a,(key_t_q)
ck2_up2:		and	2
ck2_up3:		add	a,254
			ld	a,c
			adc	a,a
			ld	c,a
ck2_down1:		ld      a,(key_g_a)
ck2_down2:		and	2
ck2_down3:		add	a,254
			ld	a,c
			adc	a,a
			ld	c,a
                	ret

;*************
;control_key3: Keyboard 3 control routine
;*************
control_key3:   	ld	c,0		;Same as control_key1
ck3_right1:		ld      a,(key_h_en)
ck3_right2:		and	2
ck3_right3:		add	a,254
			ld	a,c
			adc	a,a
			ld	c,a
ck3_left1:		ld      a,(key_h_en)
ck3_left2:		and	4
ck3_left3:		add	a,252
			ld	a,c
			adc	a,a
			ld	c,a
ck3_up1:		ld      a,(key_h_en)
ck3_up2:		and	16
ck3_up3:		add	a,240
			ld	a,c
			adc	a,a
			ld	c,a
ck3_down1:		ld      a,(key_b_sp)
ck3_down2:		and	8
ck3_down3:		add	a,248
			ld	a,c
			adc	a,a
			ld	c,a
                	ret

;*************
;control_key4: Extra keys control routine
;*************
control_key4:   	ld	c,0		;Same as control_key1, but keys will be used for camera changes, pause and sound
ck4_right1:		ld      a,(key_t_q)
ck4_right2:		and	16
ck4_right3:		add	a,240
			ld	a,c
			adc	a,a
			ld	c,a
ck4_left1:		ld      a,(key_y_p)
ck4_left2:		and	16
ck4_left3:		add	a,240
			ld	a,c
			adc	a,a
			ld	c,a
ck4_up1:		ld      a,(key_g_a)
ck4_up2:		and	8
ck4_up3:		add	a,248
			ld	a,c
			adc	a,a
			ld	c,a
ck4_down1:		ld      a,(key_g_a)
ck4_down2:		and	16
ck4_down3:		add	a,240
			ld	a,c
			adc	a,a
			ld	(extra_keys),a
                	ret

;***************
;menu_testlegal: Check if a certain car control option is legal or not, depending on the number of cars already controlled by humans or that don't race
;***************
menu_testlegal:		ld	a,(car1+SP_CONTOPT)
			ld	b,a			;B = Control option for car 1
			ld	a,(car2+SP_CONTOPT)
			ld	c,a			;C = Control option for car 2
			ld	a,(car3+SP_CONTOPT)
			ld	d,a			;D = Control option for car 3
			ld	a,(car4+SP_CONTOPT)
			ld	e,a			;E = Control option for car 4
			ld	a,9
			call	testlegal_chkz		;Check how many cars have the option 9 (don't race)
			ld	a,2
			cp	l
			ret	c			;If above 2, exit with carry (illegal)
			ld	a,5
			call	testlegal_chkc		;Check how many cars have the option below 5 (human)
			ld	a,2
			cp	l
			ret	c			;If above 2, exit with carry (illegal)
			ret	nz			;If not 2, exit without carry (legal)

			ld	h,0			;Start with 0
tl_nocollis:		ld	a,h
			call	testlegal_chkz		;Check how many cars have option A
			ld	a,1
			cp	l
			ret	c			;If above 1, exit with carry (illegal) -> both cars have the same control
			ld	a,h
			inc	a
			ld	h,a			;Next value
			cp	6
			jr	nz,tl_nocollis		;Keep trying from 0 to 5
			ret

;****************
;tohaltwithsound: wait for next retrace and beep the sound effect
;****************

tohaltwithsound:	xor	a
			ld	r,a			;Reset bit 7 of R
			ld	e,0
snd_state:		ld	a,0
			ld	d,a
			and	2			;Are we in collision?
			jr	z,snd_speed
			ld	e,20			;Additional value for collision
snd_speed:		ld	a,0			;Sound depends on current speed
			add	a,e
			ld	e,a
			jr	nz,youwillbeep
			ld	a,d
			and	4
			jr	nz,WaitInt	;If state has bit 2 set, don't beep
youwillbeep:		ld	a,36
			sub	e
			add	a,a
			add	a,a
			ld	e,a
			add	a,a
			ld	d,a
			ld	c,1
			call	Beep		;Call the beep routine

PlayOut:		xor	a		
			out	(254),a		;Clear beeper bit
WaitInt:		ld	a,r
			jp	p,WaitInt	;Wait till the next interrupt sets the high bit of R
			ret

Beep:			ld	a,16
			out	(254),a		;Beeper bit at 1, border remains 0
			ld	b,e
Beep0:			ld	a,r
;			ret	m
			nop
			nop
			djnz	Beep0
			jr	Beep1

Beep1:			ld	a,0
			out	(254),a		;Beeper bit at 0, border remains 0
			ld	b,d
Beep2:			ld	a,r
;			ret	m
			nop
			nop
			nop
			nop
			djnz	Beep2
			dec	c
			ret	z
			jr	Beep
			nop
			nop

;***************			
;micropause_snd: Let Orfeus (if enabled) play during 0.06 seconds
;***************
micropause_snd:		push	bc		;Keep registers
			push	de
			push	hl
			push	af
			ld	a,3		;3 frames
			call	orfeus_reentry	;Call Orfeus
			pop	af
			pop	hl
			pop	de
			pop	bc		;Restore registers
			ret
			
;***************
;orfeus_reentry: Orfeus reentry routine, to keep playing from where it left, during A interrupts
;***************
orfeus_reentry:		jr	orfeus_reentry_real	;Jump to the real orfeus reentry routine
orfeus_reentry_fake:	halt				;Fake orfeus reentry routine, for 128k models
			dec	a
			jr	nz,orfeus_reentry_fake
			ret
orfeus_reentry_real:	ld	(orfeustimer+1),a	;Keep number of frames
			di
			ld 	hl, $89f3
			ld 	(interrupt_redir+1),hl	;Interrupt redirection inside orfeus
			ld 	(stackback+1),sp	; Return stack pointer
stackback2:		ld 	sp,0			;New STACK POINTER
			pop 	bc
			exx
			pop 	bc
			pop 	de
			pop 	hl
			pop 	af			;Restore old registers
			ret				;Return
before_orfeus:
			INCLUDE "orfeus.asm"		;Orfeus player+song
after_orfeus:		
			INCLUDE "variables.asm"		;All variables

			ORG	mapa			;Mapa buffer, will be overwritten by the map later
			INCBIN	"bindata/cezgs.exp"	;CEZGS logo, to be shown at start
IF STEPN=2
	labpacked:		INCBIN	"bindata/labels.exp"	;Labels packed, to be unpacked at their proper position after the logo (and maybe the egg) is shown.
ENDIF
;********************************************************************************
; Code

			ORG	42240
stackorfeus_limit:
mapssmal_comp:		INCBIN  "bindata/mapssmal.exp"	;Miniature maps, for records page and personalization, compressed
			INCLUDE "data/championships.asm";Championships data

;**********
;endreplay: End replay of race
;**********
endreplay:		ld	hl,end_stage_normal
			ld	(end_stage+1),hl	;Restore end_stage routine for the next time
			ld	a,1
			ld	(recording),a		;Recording variable at 1
			call	setbank			;Set bank 1
			ld	hl,49152	
			ld	de,car1
			ld	bc,end_cars-car1
			ldir				;Copy all cars data
			call	setbank0		;Restore bank 0
			jp	end_stage_reentry	;Go back to end stage interlude

;************
;silencia_ay: Silence the AY chip
;************
silencia_ay:		ld	a,(is128k)
			and	a
			ret	z			;Exit if we're not in 128k
			ld	a,6
			di				;Disable interrupts
			call	setbank			;Set bank 6
			call	SILENCIAPLAYER		;Call SILENCIAPLAYER routine
			call	setbank0		;Set bank 0
			ld	hl,int_end
			ld	(interrupt_redir+1),hl	;Do nothing on interrupts
			ei				;Enable interrupts again			
			ret


                	INCLUDE	"ins128.asm"		;128k only routines

;*****
;menu: Main menu routine
;*****
menu:			jr	menu48			;Jump to 48k menu
menu128:		di				;128k: Disable interrupts
			ld	a,6
			call	setbank			;Set bank 6
			call	vortex_start		;Start Vortex tracker
        		call	setbank0		;Set bank 0
        		ei				;Enable interrupts
			ld	hl,rainbow
			ld	(interrupt_redir+1),hl	;Call to rainbow routine on interrupts
			jr	menu_reprint
menu48:			ld	a,1
			ld	(orfeustimer+1),a
			call	orfeus_start		;Start Orfeus song
menu_reprint:		ld	hl,menulogo		;
			xor	a
			ld	(rainbow_disable+1),a	;Disable Rainbow while uncompressing I Need Speed logo
			call	deexo_screen		;Uncompress I Need Speed logo
			ld	a,1
			ld	(rainbow_disable+1),a	;Enable rainbow
			ld	bc,mmenu_fixed
			call	printmessage		;Print fixed menu message
menuprint:		call	menuprintcontrols	;Print menu controls

menu_resetc:		ld	c,0			;Reset counter
menu_outwaitres:	ld	b,4
menu_inwaitres: 	push	bc
			ld	bc,mmenu_0start
			call	printmessage		;Print "0 TO START" message
			ld	a,3
			call	orfeus_reentry		;Call Orfeus for 3 frames
					;MENU KEYS ACTION START
			ld	b,4			;4 keys to be tested
			ld	ix,car1			;First car
			ld	de,car2-car1
			ld	a,(key_5_1)		;Read keys 5-1
menu_testkey:		rrca				;Check for keys 1-4
			jp	nc,menu_changecontrol	;If any is enabled, go to change its corresponding control
			add	ix,de			;IX points to next car
			djnz	menu_testkey		;Loop for all cars
			rrca				;Check for key 5
			jp	c,menu_noredefine

			call	pmess_select_center	;We're redefining, select centered characters
			ld	a,43			;dec hl opcode
			ld	(rede_patch1),a		;Patch code, so we advance just 1 space in the message
			ld	a,mmenu_rede_pause%256
			ld	(rede_patch2+1),a	;Patch the limit to be checked
			call	wait_nokey		;Wait for no key to be pressed
			ld	bc,mmenu_keyfor
			call	printmessage		;Print the "KEY FOR " message
			xor	a
			ld	(keysredefined),a	;Reset the number of defined keys so far
			ld	ix,car1			;First car
			ld	b,4			;Number of cars

menured_checkkeys:	ld	a,(ix+SP_CONTOPT)	;For each car, take the control option
			ld	hl,mmenu_keys1_def	;Message with current KEY1 keys
			ld	iy,ck1_right1+1		;Place to start patching control_key1 routine
			and	a			;0?
			call	z,redefinekeys		;Yes (KEY1): go to redefine
			ld	hl,mmenu_keys2_def	;Same with the three key control routines
			ld	iy,ck2_right1+1
			dec	a			
			call	z,redefinekeys
			ld	hl,mmenu_keys3_def
			ld	iy,ck3_right1+1
			dec	a
			call	z,redefinekeys
			ld	de,car2-car1
			add	ix,de			;Point to next car
			djnz	menured_checkkeys	;Repeat for all cars

			ld	a,35			;inc hl opcode
			ld	(rede_patch1),a		;Patch code, so we advance 3 spaces in the message
			ld	a,mpause_pause%256
			ld	(rede_patch2+1),a	;Patch the limit to be checked
			ld	hl,mmenu_keypause	;Message with current control keys
			ld	iy,ck4_right1+1		;Place to start patching control_key4 routine
			call	redefineextra		;Redefine the extra keys
			jp	menu_changeoption2	;Go back to menu, with a change

;**************
;redefineextra: Redefine the extra keys
;**************
redefineextra:		push	af
			push	bc
			push	ix
			ld	bc,mmenu_rede_pause	;Messages for extra keys
			jp	rede_nextkey

;*************
;redefinekeys: Redefine 4 movements keys
;*************
redefinekeys:		push	af
			push	bc
			push	ix
			ld	bc,mmenu_rede_right	;Messages for movement keys
rede_nextkey:		push	hl
			push	bc
			push	hl
			ld	a,CHR_INTERR
			ld	(hl),a			;Put an interrogation symbol in questioned key
			push	bc
			push	hl
			call	menuprintcontrols	;Print menucontrols to display that symbol
			call	micropause_snd		;Make a small pause while the menu music still sounds
			pop	hl
			pop	bc
			ld	de,18510		;Fixed message position, right after "KEY FOR "
			call	printmessage		;Print the name of the key we're looking for
			call	get1key			;Get 1 key that's not been pressed before
			pop	hl
			ld	(hl),a			;Put the new key in the place of the interrogation symbol
			call	menuprintcontrols	;Print the menucontrols with the new key
			call	micropause_snd		;Make a small pause while the menu music still sounds
			pop	bc
			ld	hl,7
			add	hl,bc
			ld	b,h
			ld	c,l			;Advance to next movement/special key name
			pop	hl			;HL points to current key
			inc	hl
			inc	hl
rede_patch1:		dec	hl			;Advance 1 or 3 positions
			ld	a,c
rede_patch2:		cp	mmenu_rede_pause%256	;Check if we're at the last key
			jr	nz,rede_nextkey		;If not, keep redefining
			pop	ix
			pop	bc
			pop	af
			ret

;*******************
;menu_changecontrol: Change control of 1 of the 4 players, to the next legal value
;*******************
menu_changecontrol:	ld	a,(ix+SP_CONTOPT)	;Current control
			inc	a			;Increase it
			cp	10			;Reached 10?
			jr	nz,menu_noxora
			xor	a			;Yes: set to 0
menu_noxora:		ld	(ix+SP_CONTOPT),a	;Store new value
			and	a
			call	menu_testlegal		;Check if the new value is legal
			jr	c,menu_changecontrol	;If not, change again
			jr	menu_changeoption2	;Legal: go back to menu, with a change


;****
;menu continues here...
menu_noredefine:	ld	a,(key_6_0)		;check 6_0 semirow
			and	16			;6 pressed?
			jr	nz,menu_nochangecat
							;Yes: change category
			ld	a,(mode)		;Get current one
			dec	a			;Decrease value
			and	3			;Keep it in 0-3 range
			ld	(mode),a		;Store new value
			add	a,a
			ld	e,a
			add	a,a
			add	a,e			;Multiply by 6
			ld	e,a
			ld	d,0
			ld	hl,mmenu_cat0
			add	hl,de			;Get category name in HL
			ld	de,mmenu_category	;Place to store that name
			ld	bc,6
			jr	menu_changeoption	;Go back to menu, changing an option with LDIR

menu_nochangecat:	ld	a,(key_6_0)		;Get 6-0 semirow state
			and	8			;Test key 7
			jr	nz,menu_nochangechamp	;If it wasn't pressed, don't change championship
			ld	a,(championship)	;Read championship variable
			inc	a			;Increase it
			and	3			;Cycle 4 values
			ld	(championship),a	;Update championship
			rrca
			rrca
			rrca				;Offset = championship*32
			ld	h,championships_data/256
			ld	l,a			;HL points to selected championship name
			ld	de,mmenu_champion	;Championship name in menu message
			ld	bc,10			;10 characters to be copied
menu_changeoption:	ldir				;Update data
menu_changeoption2:	call	micropause_snd		;Do a micropause
			call	menuprintcontrols	;Print menu controls
			pop	bc			;Restore counter
			ld	a,c
			and	3
			ld	c,a			;Keep only the lower 2 bits of C
			push	bc

menu_nochangechamp:	ld	a,(key_6_0)		;Get 6-0 semirow state
			and	4			;If 8 is pressed
			jp	z,menu_personalize	;Go to personize routine

			ld	a,(key_6_0)		;Get 6-0 semirow state
			and	1			;0 pressed?
			pop	bc			;(restore menu counter)
			jp	z,start_game		;If 0 is pressed, start the game
					;MENU KEYS ACTION END

			dec	b			;Time counter
			jp	nz,menu_inwaitres	;Loop
			inc	c			;Another time counter
			ld	a,c
			cp	50
			jp	nc,menu2		;After some time passes, go to menu2 (credits)
			and	3			;Get two lower bits from the counter
			rrca
			jr	c,menu_centerit		;If bit is 1, center chars for "0 TO START"
			jr	z,menu_leftit		;If value is 0, left inclination chars for "0 TO START"
			call	pmess_select_right	;Otherwise, right inclination chars for "0 TO START"
			jp	menu_outwaitres
menu_centerit:		call	pmess_select_center
			jp	menu_outwaitres
menu_leftit:		call	pmess_select_left
			jp	menu_outwaitres

;*****************
;menu_personalize: Personalize the personal championship
;*****************
menu_personalize:	ld	hl,mapssmal_comp
			ld	de,mapa			
			xor	a
			ld	(rainbow_disable+1),a	;Disable rainbow effect
			call	deexo			;Uncompress micromaps into mapa buffer
			ld	hl,menulogo
			call	deexo_screen		;Uncompress menu logo
			ld	a,1
			ld	(rainbow_disable+1),a	;Enable rainbow effect
			call	pmess_select_center	;Centered characters
			ld	bc,mmapsnumber
			call	printmessage		;Print numbers over small maps
			ld	bc,mpers_init
			call	printmessage		;Print personalization message
			ld	a,3
			ld	(championship),a	;Select PERSONAL championship
			ld	hl,championship_personal
			ld	de,mmenu_champion
			ld	bc,10
			ldir				;Update menu message with PERSONAL
			call	putmapsdown		;Put all micromaps in the screen
mpers_tracks_add:	call	putmiddlemicromaps	;Put micromaps of the current personal championship in the middle of the screen
			call	updatepersdata		;Update data
mpers_tracks:		ld	de,championship_personal+24
			ld	a,(person_maps)		;Get number of maps
			cp	8
			jr	nz,mpers_nodec
			dec	a			;If it's 8, decrease it
mpers_nodec:		add	a,e
			ld	e,a			;Point to magenta map
mpers_trackget:		call	getkey_personalize	;B=KEY 0-9, carry back if ENTER
			call	micropause
			jp	c,mpers_laps		;Enter -> Laps
			ld	a,b
			and	a
			jr	z,mpers_trackget	;0 not used
			cp	9
			jr	z,mpers_erasetrack	;9->erase
			dec	a
			add	a,a			;2*(number-1)
			ld	(de),a			;Store map code
			ld	a,-8
			add	a,e
			ld	e,a
			ld	a,2
			ld	(de),a			;Default 2 laps for the new map
			jr	mpers_tracks_add

mpers_erasetrack:	ld	a,(person_maps)		;Get number of maps
			and	a
			jr	z,mpers_trackget	;Don't erase if we're at the first map
			dec	a			;Decrease the number of maps
			jr	z,mpers_erasetrackfirst	;First map is a special case
			ld	e,(championship_personal+16)%256
			add	a,e			;
			ld	e,a
			xor	a
			ld	(de),a			;0 the map erased
			jr	mpers_tracks_add
mpers_erasetrackfirst:	ld	de,22720		;Attribute address
			ld	a,3			;Color
			call	attrblock4x4		;Put magenta 4x4 block
			ld	a,5
			ld	b,1
			call	attrblock4x		;Clear laps line
			ld	de,22724
			xor	a
			call	attrblock5x4		;Black over the second map
			ld	de,championship_personal+24
			jr	mpers_trackget		;Keep getting tracks
		;Laps
mpers_laps:		ld	de,22720
			ld	hl,championship_personal+16
			ld	a,(person_maps)		;Get number of personal maps
			and	a
			jr	z,mpers_nodec2
			dec	a			;Decrease to start by 0
mpers_nodec2:		add	a,a
			add	a,a
			add	a,e
			ld	e,a
			ld	a,5
			push	de
			call	attrblock4x4		;Paint last map cyan
			pop	de
			ld	a,4
			add	a,e
			ld	e,a
			cp	224			;If we're not at the end
			jr	z,mpers_lapsstart
			xor	a
			call	attrblock4x4		;Clear next map
mpers_lapsstart:	ld	hl,championship_personal+16
			ld	de,mpers_laps0		;Point to laps per track message
mpers_laploop:		ld	a,CHR_INTERR
			ld	(de),a			;Put an interrogation over the number of laps we're asking for
			push	bc
			push	de
			push	hl
			ld	bc,mpers_param
			call	printmessage		;Update message to make the interrogation appear
			call	getkey_personalize	;Get a key
			call	micropause		;Do a pause
			ld	a,b
			pop	hl
			pop	de
			pop	bc
			jr	c,mpers_scores_fromenter ;Enter -> Scores
			and	a
			jr	z,mpers_laploop		;No 0
			cp	9
			jr	z,mpers_gobacklap	;Go back
			cp	6
			jr	nc,mpers_laploop	;No 6-8
			ld	(hl),a			;Store number of laps
			add	a,CHR_0			;Turn into a character
			ld	(de),a			;Store it in message, in place of the interrogation
			inc	hl			;Point to the number of laps in next track (in championship data)
			inc	de
			inc	de
			inc	de			;Point to the number of laps in next track (in message)
			ld	a,(hl)			;Get number of laps of the next track
			and	a
			jr	nz,mpers_laploop	;If it's not zero, ask for it again
			jr	mpers_scores		;Otherwise, go to scores part
mpers_gobacklap:	ld	a,(hl)
			add	a,CHR_0			
			ld	(de),a			;Restore message with previous number of laps instead of the interrogation mark
			dec	hl			;Point to the number of laps in previous track (in championship data)
			dec	de
			dec	de
			dec	de			;Point to the number of laps in previous track (in message)
			ld	a,l
			cp	(championship_personal+15)%256	;Check if we were in the first track
			jp	z,mpers_tracks_add	;If so, go back to tracks part
			jr	mpers_laploop		;Go ask for the number of laps again
		;Scores
mpers_scores_fromenter:	ld	a,(hl)
			add	a,CHR_0
			ld	(de),a			;Turn the last interrogation mark into the number of laps
mpers_scores:		ld	hl,championship_personal+11
			ld	de,mpers_points1	;Point to points per position message
mpers_scoresloop:	ld	a,CHR_INTERR		;Interrogation
			ld	(de),a
			push	bc
			push	de
			push	hl
			ld	bc,mpers_param
			call	printmessage		;Update message to make the interrogation appear
			call	getkey_personalize	;Get a key
			call	micropause		;Do a pause
			ld	a,b
			pop	hl
			pop	de
			pop	bc
			jp	c,menu			;ENTER: We're done
			cp	9
			jr	z,mpers_gobackscore	;9: Go back
			cp	7
			jr	nc,mpers_scoresloop	;No 7-8
			ld	(hl),a			;Store score
			add	a,CHR_0			;Turn it into a character
			ld	(de),a			;Store it in message, in place of the interrogation
			inc	hl			;Point to the score for the next position (in championship data)
			inc	de
			inc	de
			inc	de			;Point to the score for the next position (in message)
			ld	a,l
			cp	championship_personal+16
			jr	nz,mpers_scoresloop

mpers_scoresdone:	push	bc
			push	de
			push	hl
			ld	bc,mpers_param
			call	printmessage		;Clear last interrogation
			call	getkey_personalize	;Get a key
			call	micropause		;
			ld	a,b
			pop	hl
			pop	de
			pop	bc
			jp	c,menu			;ENTER: We're done
			cp	9
			jr	nz,mpers_scoresdone	;Not 9 key: keep trying
			jr	mpers_gobacknorest	;9: Go back to the score for best lap
mpers_gobackscore:	ld	a,(hl)
			add	a,CHR_0
			ld	(de),a			;Restore previous interrogation
mpers_gobacknorest:	dec	hl			;Point to the score for the previous position (in championship data)
			dec	de
			dec	de
			dec	de			;Point to the score for the previous position (in message)
			ld	a,l
			cp	(championship_personal+10)%256
			jr	nz,mpers_scoresloop	;If we were not in the first points, go back to the previous one

			ld	a,(person_maps)		;Get number of tracks
			ld	de,mpers_laps0-3	;number of laps message
mpers_gobacklastlap:	inc	de
			inc	de
			inc	de			;Advance a position in message
			dec	a
			jr	nz,mpers_gobacklastlap	;Advance to the last map
			ld	hl,championship_personal+15
			ld	a,(person_maps)
			add	a,l
			ld	l,a			;HL points to the number of laps for the last track
			jp	mpers_laploop		;Go to laps part

;******
;menu2: Display the credits
;******
menu2:			ld	hl,menulogo
;			di
			xor	a
			ld	(rainbow_disable+1),a	;Disable rainbow effect
			call	deexo_screen		;Uncompress logo screen
			ld	a,1
			ld	(rainbow_disable+1),a	;Enable rainbow effect
;			ei
			call	pmess_select_center	;Center text
			ld	bc,message_credits
			call	printmessage		;Print credits message
			ld	bc,200			;Counter
menu2_loop:		push	bc
			ld	a,3
			call	orfeus_reentry		;Make Orfeus sound for 3 frames
			call	check_key		;Check if a key has been pressed
			pop	bc
			jp	nz,menu_reprint		;If a key was pressed, go back to menu
			dec	bc
			ld	a,b
			or	c
			jr	nz,menu2_loop		;Keep looping for 12 seconds, then go to Records part

;******
;menu3: Display the fast lap records for all tracks and categories. If any record is shared, the colors will be swapping.
;******
menu3:			ld	hl,mapssmal_comp
			ld	de,mapa
;			di
			xor	a
			ld	(rainbow_disable+1),a	;Disable rainbow effect
			call	deexo			;Uncompress micromaps into mapa buffer
			ld	hl,menulogo
			call	deexo_screen		;Uncompress menu logo
			ld	a,1
			ld	(rainbow_disable+1),a	;Enable rainbow effect
;			ei
			call	putmapsdown		;Put the micromaps down
			ld	bc,mmapsnumber
			call	printmessage		;Put the numbers above the micromaps
			ld	bc,mrecords_fixed
			call	printmessage		;Put the records fixed message

			ld	hl,mapas+6
			ld	de,18432+2
menu3_numbers_outer:	ld	b,4			;Number of categories
			push	de
menu3_numbers_inner:	push	bc
			push	de
			push	hl
			ld	a,(hl)
			inc	hl
			ld	l,(hl)
			ld	h,a			;Get record time in HL
			call	timeprint3		;Print record into time message
			ld	bc,mes_mt_m10
			call	printmessage		;Print it
			pop	hl
			inc	hl
			inc	hl			;Next record time
			pop	de
			ld	a,e
			add	a,8
			ld	e,a			;Point to next position
			pop	bc
			djnz	menu3_numbers_inner	;Do it for all 4 categories
			ld	bc,8
			add	hl,bc			;Point to next track
			pop	de
			ld	a,e
			add	a,32			;Next line
			ld	e,a
			jr	nc,menu3_numbers_outer	;Do it for all tracks

			ld	hl,mapa
			ld	de,mapa+1
			ld	bc,3073
			ld	a,7
			ld	(hl),a
			ldir				;Create 12 attribute maps in mapa buffer, fill everything with white color
			ld	b,2			;b=512 bytes (256 ldi instructions)
			ld	a,160
			ld	(hl),a			;LDI opcode second byte
			dec	hl
			ld	a,237			;LDI opcode first byte
			ld	(hl),a
			ldir				;Fill with LDI
			ld	a,201			;RET opcode
			ld	(hl),a			;Set RET
			ld	hl,mapas+2		;Point to record holder of first map
			ld	de,mapa			;Point to first attribute map
menu3_colors_outer:	ld	b,4			;4 car colors to test
menu3_colors_inner:	ld	a,(hl)			;Who got the record?
			and	a
			jr	z,menu3_colors_white	;If 0, nobody set a record yet -> leave it white
			push	bc
			push	hl
			push	de
			ld	b,4
			ld	ix,mapa_tablecolors	;Colors table
			ld	iy,carcolors		;Color for each car
			ld	l,0			;Number of colors counter
			ld	h,a			;H has the records holders now
menu3c_find:		rrc	h			;Next is a record holder?
			jr	nc,menu3c_notthis
			ld	a,(iy)			;Get color for this car
			bit	3,h			;Human or not?
			jr	z,menu3c_notbright
			add	a,64			;If human, bright color
menu3c_notbright:	ld	(ix),a			;Set color in table
			inc	ix			;Next position in table
			inc	l			;Increase number of colors
menu3c_notthis:		inc	iy			;Next car
			djnz	menu3c_find		;Test all car colors
					;Here: L=number of colors, table in ix
			ld	c,12			;Number of color maps
menu3c_outer2:		ld	ix,mapa_tablecolors
			ld	h,l			;H = counter
menu3c_middle2:		ld	b,5			;5 chars to set color
			ld	a,(ix)
menu3c_paint:		ld	(de),a			;Paint map with color
			inc	e			;Next position
			djnz	menu3c_paint		;Do it for all 5 characters
			ld	a,e
			sub	5
			ld	e,a			;Restore position
			inc	d			;Next color map
			dec	c
			jr	z,menu3c_exithere	;Exit if all 12 color maps have been filled
			inc	ix			;Next color from the table
			dec	h			;If we've done all colors from the table
			jr	nz,menu3c_middle2
			jr	menu3c_outer2		;Restart from the first again
menu3c_exithere:	pop	de
			pop	hl
			pop	bc
menu3_colors_white:	inc	hl			;Next category

			ld	a,e
			add	a,8			;Next screen position
			ld	e,a
			djnz	menu3_colors_inner	;Loop for all categories
			jr	c,menu3_doloop		;If carry is set, we've just finished the last, so exit here
			ld	bc,12
			add	hl,bc			;Advance to next track
			jr	menu3_colors_outer	;Repeat till all records are done

menu3_doloop:		ld	bc,200			;Main counter
			ld	hl,mapa			;First map color
menu3_loop:		push	bc
			push	hl
			ld	a,3
			call	orfeus_reentry		;Pause of 3 frames while Orfeus plays
			call	check_key		;Check for a key
			pop	hl
			jr	nz,menu_toreprint	;If a key is pressed, go back to menu
			ld	de,22787
			call	lotsofldis		;Otherwise dump the color map into the second third attributes
			ld	a,h
			cp	(mapa/256)+12		;Final?
			jr	nz,menu3_loop_noback
			ld	hl,mapa			;Start again from the first
menu3_loop_noback:	pop	bc
			dec	bc			;Decrease counter
			ld	a,b
			or	c
			jr	nz,menu3_loop		;Keep looping
			jp	menu_reprint		;Go back to menu

menu_toreprint:		pop	bc			;Discard value in stack
			jp	menu_reprint		;Go back to menu

;***********
;start_game: Start the whole championship
;***********
start_game:		ld	a,(is128k)
			and	a
			jr	z,stg_48k
			ld	a,6			;Only executed in 128k mode
			di				;Disable ints
			call	setbank
			call	MUTE			;Mute Vortex
			call	setbank0
			ld	hl,int_end
			ld	(interrupt_redir+1),hl	;Disable rainbow effect
			ei				;Enable ints
stg_48k:		ld	a,128
			ld	(tr_col3),a
			ld	(tr_col4),a		;Black color
			ld	bc,4*256+4		;B = 4 (to loop all cars), C = 4 (number of running cars)
			ld	ix,car1			;First car
			ld	iy,camera_left		;Left camera
			xor	a
			ld	(humans),a		;Reset number of humans
			ld	(cpus),a		;Reset number of CPUs
			ld	(aborted),a		;Reset aborted state
			ld	(currentmap),a		;Reset current map number
sg_preparecar:		ld	a,mapa_checks/256
			ld	(ix+SP_NOVICE),a	;Default checkpoints, high part of address
			ld	a,(ix+SP_CONTOPT)	;Get control option
			cp	9
			jr	z,sg_outofrace		;Skip if it's out of race
			ld	hl,control_key1		;Control for keyboard 1
			and	a
			jr	z,sg_setcontrol		;Set human control if CONTOPT==0
			ld	hl,control_key2		;Control for keyboard 2
			dec	a
			jr	z,sg_setcontrol		;Set human control if CONTOPT==1
			ld	hl,control_key3		;Control for keyboard 3
			dec	a
			jr	z,sg_setcontrol		;Set human control if CONTOPT==2
			ld	hl,control_sinc1	;Control for Sinclair 1
			dec	a
			jr	z,sg_setcontrol		;Set human control if CONTOPT==3
			ld	hl,control_sinc2	;Control for Sinclair 2
			dec	a
			jr	z,sg_setcontrol		;Set human control if CONTOPT==4
			ld	hl,control_kemp		;Control for Kempston joystick
			dec	a
			jr	z,sg_setcontrol		;Set human control if CONTOPT==5
			ld	hl,96*256+80		;H=96, L=80, D=64 for EASY CPU
			ld	d,64
			dec	a
			jr	z,sg_setcpucontrol	;Set CPU control if CONTOPT==6
			ld	hl,112*256+96		;H=112, L=96, D=16 for NORMAL CPU
			ld	d,16
			dec	a
			jr	z,sg_setcpucontrol	;Set CPU control if CONTOPT==7
			ld	hl,128*256+128		;H=128, L=128, D=0 for HARD CPU
			ld	d,0
							;Set CPU control, because CONTOPT=8
sg_setcpucontrol:	ld	(ix+SP_IARAND1),h
			ld	(ix+SP_IARAND2),l
			ld	(ix+SP_IARAND3),d	;Fill AI constants
			ld	hl,control_varied	;Control routine
			ld	a,(cpus)
			inc	a
			ld	(cpus),a		;Increase number of CPU controlled cars
			jr	sg_nothuman
sg_setcontrol:		ld	a,(humans)
			inc	a
			ld	(humans),a		;Increase number of human controlled cars
			ld	a,(mode)
			and	1
			add	a,(ix+SP_NOVICE)	
			ld	(ix+SP_NOVICE),a	;If category is JUNIOR or GP2, use novice checkpoints instead
sg_nothuman:		ld	(ix+SP_CONTROL+1),h
			ld	(ix+SP_CONTROL),l	;Set control routine
			ld	(ix+SP_CONTROLBAK+1),h
			ld	(ix+SP_CONTROLBAK),l	;Set backup control routine
sg_finaltouchs:		ld	a,(ix+SP_MASTCOL)
			ld	(ix+SP_COLOR),a		;Restore color
			xor	a			;Initial state at 0
			jr	sg_nextcar
sg_outofrace:		dec	c			;Decrease number of running cars
			ld	a,67
			ld	(ix+SP_COLOR),a		;Black color with bright, to make it come down in main marker when sorting cars
			ld	a,16			;Bit 4 of state high > Don't race
sg_nextcar:		ld	(ix+SP_STATE),a		;Set initial state
			xor	a
			ld	(ix+SP_POINTS),a	;Clear points
			ld	de,car2-car1
			add	ix,de			;Point to next car
			dec	b
			jp	nz,sg_preparecar	;Loop for all 4 cars
			ld	a,c
			ld	(nactive_cars+1),a	;Set number of active cars
			
			ld	a,(mode)		;Prepare speeds according to category
			add	a,a
			add	a,a
			add	a,a
			add	a,a
			ld	l,a
			ld	h,0
			ld	de,spd_0		;Base table
			add	hl,de			;Once the address of speed table that we're going to use is calculated...
			push	hl
			ld	de,speeds_base		;Take it out
			ld	bc,16
			ldir				;...copy the 16 bytes to the speed table that will be used in the game
			pop	hl
			ld	bc,6
			ldir				;Repeat 6 first bytes from that table
							;Start stage entrance point

;************
;start_stage: Start the next stage
;************
start_stage:		call	pmess_select_center
			call	wait_key		;Wait for key
			ld	a,tablepoints%256
			ld	(tablepointer),a
			xor	a
			ld	(tableadvance),a	;Default no advance in tablepoints
			ld	(positionwin),a 	;Reset position counter to 0
			ld	(minimap_cycle),a 	; and minimap_cycle too
			ld	bc,4*256+2		;B=4 (number of cars), C=2 (number of cameras)
			ld	ix,car1			;First car
			ld	iy,camera_left		;Left camera
setcamloop:		ld	e,(ix+SP_CONTOPT)	;Get control option
			ld	a,5
			cp	e			;Below 5?
			jr	c,setcam_nohum	
			ld	a,(ix+SP_CAMERA)
			ld	(iy+CAM_CAR),a		;Set camera
			set	7,(ix+SP_STATE)		;Set human bit
			dec	c
			ld	iy,camera_right
setcam_nohum:		ld	de,car2-car1
			add	ix,de			;Point to next car
			djnz	setcamloop		;Loop to set cameras to point cars controlled by humans
			ld	a,c
			and	a
			jr	z,camerasallset		;If all cameras are set, skip to next part

			ld	b,4			;4 cars
			ld	ix,car1			;First car
setcamloop2:		ld	e,(ix+SP_CONTOPT)	;Get control option
			ld	a,e
			cp	6
			jr	c,setcam_nocpu		;Below 6, it ain't CPU
			cp	9
			jr	z,setcam_nocpu		;Neither is 9
			ld	a,(ix+SP_CAMERA)
			ld	(iy+CAM_CAR),a		;Set camera
			dec	c
			ld	iy,camera_right		;Next camera to set
setcam_nocpu:		ld	de,car2-car1
			add	ix,de			;Point to next car
			djnz	setcamloop2		;Repeat loop for all cars

camerasallset:		ld	hl,0
			ld	(main_ticks),hl		;Reset main timer
			ld	a,CHR_0_
			ld	(message_cl_m1),a	;Set 0 to clock in minute units
			ld	hl,message_cl_m10
			ld	a,CHR_0
			ld	(hl),a			;Set 0 to clock in minute tens
			inc	hl
			inc	hl
			ld	(hl),a			;and second tens
			inc	hl
			ld	(hl),a			;and second units
			di
			ld	a,(is128k)
			and	a			;Check if 128k mode
			jr	z,noloadwyzplayer
			
			ld	a,(currentmap)
			and	3			;2 bits, select between 4 songs
			ld	h,a
			call	load_wyz		;Load corresponding song in WYZplayer
			ld	a,(recording)
			cp	1
			call	z,record_preparerecord	;Prepare to record
noloadwyzplayer:	ld	a,(championship)	;Get championship number
			rrca
			rrca
			rrca				;Multiply by 32
			add	a,10			;Point to number of laps
			ld	h,championships_data/256
			ld	l,a
			ld	a,(hl)			;Get number of tracks
			add	a,16
			ld	(mfirst_total),a	;Set total number of championship tracks in the first message in marker
			inc	l			;Point to scores per positions
			ld	bc,5
			ld	de,tablepoints
			ldir				;Copy scores table, now HL points to the number of laps for first track
			ld	a,(currentmap)		;Get current track inside the championship
			add	a,l
			ld	l,a			;HL points to number of laps in current track
			ld	a,(currentmap)
			add	a,17
			ld	(mfirst_nrace),a	;Set number of track in first message in marker
			ld	a,(hl)			;Check the number of laps
			and	a
			jp	z,endgame		;End game if it is the end of championship
			ld	(current_stage_laps),a
			add	a,16
			ld	(mfirst_nlaps),a	;Set number of laps to race in the first message in marker
			ld	a,8
			add	a,l
			ld	l,a			;HL now points to track index
			ld	c,(hl)			;Get track number*2
			ld	a,c
			ld	(currentmap2),a		;Store it
			add	a,a
			add	a,a
			add	a,a
			ld	c,a			;C = track number * 16
			ld	hl,mapas
			add	hl,bc			;Address of current map in table mapas
			ld	b,(hl)
			inc	hl
			ld	h,(hl)
			ld	l,b			;Get compressed map address to uncompress it
			push	hl
			ld	hl,marcador
			call	deexo_screen		;Uncompress markers screen
			pop	hl
			call	crearmapa		;Create the map and fix the parameters
			call	minimap_draw_low	;Draw minimap at its place
			xor	a
			ld	(fastforward),a		;Disable fast-forward
			ld	(humansarrived),a	;Reset counter of humans arrived
			ld	a,3			;First time
			ld	(changemarker),a	;Signal that the marker should be updated for first time
			ei
							;Main loop entrance point

;*********
;mainloop: Main game loop, will be repeated every 5 frames, until the game is aborted or the game ends
;*********
mainloop:		ld	a,(recording)
			cp	2			;Replay?
			jr	nz,main_nocheckendrecord
			ld	hl,(max_rec_addr)	;Yes:
			ld	de,(current_rec_addr)	;check if we've reached the end of recording
			sbc	hl,de
			jp	c,end_stage		;If we've reached the end, go to end_stage

main_nocheckendrecord:	call	control_key4		;Update extra keys state
			and	4			;Check sound key
			jr	nz,main_nochangesnd	;No sound key pressed, no change on sound
			ld	a,(current_sound)	;Get current_sound variable
main_currentsoundpatch:	inc	a			;(This will be patched with a nop in 128k mode)
			inc	a			;Increase current_sound (2 states if in 48k mode, 1 otherwise)
			cp	6			;Check if we reached the limit
			jr	nz,main_storesound
			ld	a,4
			ld	(snd_state+1),a		;Disable beeper sound
			xor	a
			ld	(snd_speed+1),a		;Disable beeper sound
main_storesound:	ld	(current_sound),a	;Update current_sound variable

main_nochangesnd:	ld	a,(tableadvance)	;If any car arrived in the previous frame, advance the number of cars that arrived in the tablepointer
			ld	b,a
			ld	a,(tablepointer)
			add	a,b
			ld	(tablepointer),a
			xor	a
			ld	(tableadvance),a	;Default no advance in tablepoints
			
			call	restorebright		;Restore brightness in minimap (if any of it was removed, only happens in junior category)


			ld	b,4			;Number of cars
			ld	ix,car1			;First car
main_cars:		push	bc			;Keep number of cars
			ld	a,(recording)		
			cp	2			;Check if we're recording
			jr	nz,main_checkffnormal
			bit	7,(ix+SP_STATE)		;We're recording, check if we're a human car
			jr	z,main_nofastforwardyet	;  No: don't check for fastforward
			jr	main_tryfastforward	;  Yes: check for fastforward

main_checkffnormal:	bit	6,(ix+SP_STATE)		;We're not recording, check if we've arrived
			jr	z,main_nofastforwardyet	;  No: don't check for fastforward
			ld	a,(humansarrived)	;  Yes, check if all humans have arrived
			ld	d,a
			ld	a,(humans)
			cp	d			;All humans in?
			jr	nz,main_nofastforwardyet ; No: don't check for fastforward yet
							;  Yes: check for fastforward

main_tryfastforward:	ld	l,(ix+SP_CONTROLBAK)
			ld	h,(ix+SP_CONTROLBAK+1)
			ld	de,main_fastforwardka	;Return value
			push	de			;In the stack
			jp	(hl)			;Call the backup control routine (the main control routine might be replaced by the replay one)

main_fastforwardka:	bit	1,c			;Check up control
			ld	a,10
			jr	z,main_dofastforward	;If pressed, do fast forward
			bit	0,c			;Check down control
			jr	nz,main_nofastforwardyet
			xor	a			;If pressed, don't do fast forward
main_dofastforward:	ld	(fastforward),a		;Update fastforward variable
main_nofastforwardyet:	bit	4,(ix+SP_STATE)		;Check if the car is participating
			jp	nz,main_nocheck		;Go to next car if it's not.
			ld	a,(mode)
			cp	3			;Junior category?
			jr	nz,main_nojuniornobright;No: don't remove bright from the minimap
			bit	7,(ix+SP_STATE)		;Yes: Human?
			jr	z,main_nojuniornobright ;No: don't remove bright from the minimap
			ld	de,23048
			ld	a,(ix+SP_MAPY)		;Vertical position
			and	248			;Remove 3 lower bits
			add	a,a
			add	a,a			;Multiply by 4
			add	a,e			;Add to attribute position
			ld	e,a
			ld	a,(ix+SP_MAPX)		;Horizontal position
			rrca
			rrca
			rrca				;Divide by 8
			and	7			;Keep the lower bits
			add	a,e			;Add to attribute position
			ld	e,a			;DE = minimap attribute address of current car
			ld	a,32			;Green paper, no bright
			ld	(de),a			;Mark the car position by removing brightness

main_nojuniornobright:	ld	a,(ix+SP_SPEED)
			and	a
			call	nz,movetyres		;If speed isn't 0, move the tyres of the car
			ld	a,(ix+SP_CAMERA)
			ld	iy,camera_left
			cp	(iy+CAM_CAR)
			jp	z,main_scrollyleft	;If current car is in left camera, go to main_scrollyleft
			ld	iy,camera_right
			cp	(iy+CAM_CAR)
			jp	nz,main_noscroll	;If current car isn't in right camera either, go to main_noscroll

			ld	a,(mode)		;Check category
			and	2
			jr	nz,main_brujula_right	;If category is JUNIOR or KARTS, put compass
			ld	a,(ix+SP_LAPS)		;If not, get number of laps
			add	a,16			;Turn into a character
			jr	main_nobrujula_right
main_brujula_right:	call	brujula_rut		;Get current compass graphic address
			ld	de,charset+CHR_COPY*8
			ldir				;Copy char to CHR_COPY
			ld	a,CHR_COPY
main_nobrujula_right:	ld	(lap_right),a		;Set character in lap_right
			jr	main_scrollyright	;Continue with scroll movement

main_scrollyleft:	ld	a,(mode)		;Check category
			and	2
			jr	nz,main_brujula_left	;If category is JUNIOR or KARTS, put compass
			ld	a,(ix+SP_LAPS)		;If not, get number of laps
			add	a,16			;Turn into a character
			jr	main_nobrujula_left
main_brujula_left:	call	brujula_rut		;Get current compass graphic address
			ld	de,charset+CHR_ARROBA*8	
			ldir				;Copy char to CHR_ARROBA
			ld	a,CHR_ARROBA
main_nobrujula_left:	ld	(lap_left),a		;Set character in lap_right
			
main_scrollyright:	call	movecar_scroll		;Do car movement with scroll
			call	control			;Control car
			call	camerapanning		;Make the camera follow the action if necessary
			call	velocimetro		;Paint the speedometer
			call	timeprint_car		;Paint the car's timer
			jp	main_continue
main_noscroll:		call	movecar			;Do car movement without scroll
			call	control			;Control car

main_continue:		ld	a,(minimap_cycle)	;Check if it's this car's turn to appear in the minimap
			ld	e,a
			and	3
			cp	(ix+SP_CAMERA)
			jr	nz,main_nominimap	;No: exit this part
			ld	a,e			;Yes: check if we must put the pixel or remove it
			and	4			;Check bit
			jr	nz,main_noput
			call	minimap_put		;Put pixel
			jr	main_nominimap
main_noput:		call	minimap_quit		;Remove pixel

main_nominimap:		ld	l,(ix+SP_NEXTCHECK)	;Check if we've reached the next checkpoint
			ld	h,(ix+SP_NOVICE)	;For humans, JUNIOR and GP2 categories will check against novice checkpoints, KARTS and F1 agains the normal checkpoints
			ld	a,(ix+SP_MAPX)
			cp	(hl)
			jp	c,main_nocheck		;If the car's at the left of next checkpoint, we haven't reached it yet
			dec	a
			inc	l
			cp	(hl)
			jp	nc,main_nocheck		;If the car's at the right of next checkpoint, we haven't reached it yet
			ld	a,(ix+SP_MAPY)
			inc	l
			cp	(hl)
			jp	c,main_nocheck		;If the car's above the next checkpoint, we haven't reached it yet
			dec	a
			inc	l
			cp	(hl)
			jp	nc,main_nocheck		;If the car's below the next checkpoint, we haven't reached it yet
							;Checkpoint reached
			inc	l
			ld	(ix+SP_NEXTCHECK),l 	;Point to the next one
			ld	bc,(main_ticks)
			ld	a,l
			and	28			;For each 8 checkpoints, set a new timestamp
			jr	nz,main_checklast
			ld	a,(ix+SP_LAPS)
			ld	(ix+SP_TIMESTAMPLAP),a	;Lap for this timestamp
			ld	(ix+SP_TIMESTAMPCP),l	;Checkpoint for this timestamp
			ld	(ix+SP_TIMESTAMP+0),b	;Timestamp, high byte
			ld	(ix+SP_TIMESTAMP+1),c	;Timestamp, low byte
			ld	a,1
			ld	(changemarker),a	;Tell the marker to be updated
main_checklast:		ld	a,l
			ld	l,0
			cp	(hl)			;Check if we passed the last one
			jp	nz,main_nocheck		;No? -> continue

			ld	l,1			;Last checkpoint, back to first
			ld	(ix+SP_NEXTCHECK),l
			ld	a,1
			ld	(changemarker),a	;Tell the marker to be updated
			ld	a,(ix+SP_LAPS)
			inc	a
			ld	(ix+SP_LAPS),a		;Increase number of laps
		
			ld	(ix+SP_TIMESTAMPLAP),a	;Lap for this timestamp
			ld	(ix+SP_TIMESTAMPCP),l	;Checkpoint for this timestamp
			ld	(ix+SP_TIMESTAMP+0),b	;Timestamp, high byte
			ld	(ix+SP_TIMESTAMP+1),c	;Timestamp, low byte
		
			ld	l,a
			dec	a
			jr	z,main_firstlap		;First lap?
							;No first lap
			ld	a,c
			sub	(ix+SP_LAPSTART+1)
			ld	c,a
			ld	a,b
			sbc	a,(ix+SP_LAPSTART+0)
			ld	b,a			;bc = ticks for this lap
		
			sub	(ix+SP_BESTLAP+0)	;best lap so far?
			jr	c,main_setnewbest	;Yes: go set it
			jr	nz,main_nofirstlap	;No: don't set it
							;Maybe: check the lower byte
			ld	a,c
			sub	(ix+SP_BESTLAP+1)	;best lap so far?
			jr	c,main_setnewbest	;Yes: go set it
			jr	main_nofirstlap		;No: don't set it

main_firstlap:		ld	bc,(main_ticks)		;If it's the first lap, it will also be the best
main_setnewbest:	ld	(ix+SP_BESTLAP+0),b	;Store best lap so far
			ld	(ix+SP_BESTLAP+1),c

main_nofirstlap:	ld	a,l			;Get number of laps
			ld	hl,current_stage_laps
			cp	(hl)			;Check if we've completed all laps
			jp	nz,main_restart		;No: Continue game
							;Yes:

			set	2,(ix+SP_STATE)		;Mark winning state in car
			ld	hl,tableadvance
			inc	(hl)
			ld	a,(tablepointer)
			ld	l,a
			ld	a,(hl)
			ld	(ix+SP_MAPPOINTS),a 	;Points for this stage.
			
			bit	7,(ix+SP_STATE)		;Human?
			jr	z,main_finishednothuman
			ld	a,(humansarrived)	;If human, increase the number of finished humans
			inc	a
			ld	(humansarrived),a
			set	6,(ix+SP_STATE)		;Mark the we've arrived bit
main_finishednothuman:	ld	a,(positionwin)
			inc	a
			ld	(positionwin),a		;Increase the winning position
nactive_cars:		cp	4			;Everybody has arrived?
			jp	nz,main_nocheck		;No: Continue game
							;Yes
			call	preparemarker		;Update marker
			call	printthemarker		;Print it

			ld	c,0
main_outwaitres:	ld	b,16
main_inwaitres: 	push	bc
			ld	bc,message_presskey
			call	printmessage		;Print "PRESS KEY" message
			pop	bc
			halt
			call	check_key		;Check for key
			jr	nz,end_stage		;If pressed, go to end_stage
			dec	b
			jr	nz,main_inwaitres	;Loop a bit
			inc	c
			ld	a,c
			and	3
			ld	c,a			;Cycle values 0-3 in register C
			rrca
			jr	c,main_centerit		;If bit 0 is 1, center characters
			jr	z,main_leftit		;If C=0, characters to the left
			call	pmess_select_right	;If C=2, characters to the right
			jr	main_outwaitres
main_centerit:		call	pmess_select_center
			jr	main_outwaitres
main_leftit:		call	pmess_select_left
			jr	main_outwaitres

;**********
;end_stage: Do after playing calculations and show interlude
;**********
end_stage:		jp	end_stage_normal	;This will be patched when there's a replay
end_stage_normal:	call	record_flush		;End recording properly
end_stage_reentry:	call	silencia_ay		;Silence AY chip
			ld	hl,classification
			call	deexo_screen		;Uncompress classification screen
			call	minimap_draw_center	;Draw the minimap at the center
			ld	a,(is128k)
			and	a
			jr	z,noloadwyzplayer2
			ld	h,2
			ld	h,4			
			call	load_wyz		;Load song 4 (interlude) if we're in 128k
noloadwyzplayer2:	call	pmess_select_center	;Select centered text

			ld	b,4			;Number or cars
			ld	ix,car1			;First car
			ld	h,255			;Max time for best lap before any has been set
esta_prevloop:		push	bc
			bit	4,(ix+SP_STATE)
			jr	nz,esta_prevjumpcar	;Don't check if car isn't active
			ld	a,(ix+SP_BESTLAP)
			and	a
			jr	z,esta_prevjumpcar	;if zero, we're just aborting!
			cp	h			;For each car that didn'd abort, check if the best lap is better than the one we already had
			jr	c,esta_newbestlap
			jr	nz,esta_prevjumpcar
			ld	a,(ix+SP_BESTLAP+1)
			cp	l
			jr	nc,esta_prevjumpcar
esta_newbestlap:	ld	h,(ix+SP_BESTLAP)	;Best lap found so far in HL
			ld	l,(ix+SP_BESTLAP+1)
esta_prevjumpcar:	ld	bc,car2-car1
			add	ix,bc
			pop	bc
			djnz	esta_prevloop		;Loop with all cars
			ld	(bestlap),hl		;Store best lap

			ld	b,4
			ld	ix,car1
			ld	de,16384+100		;start address, at line 3, character 4 (100 = 32*3 + 4)
			ex	af,af'
			xor	a			;Clear A'
			ex	af,af'
esta_extloop:		ex	af,af'
			and	a			;Clear Carry in F'
			ex	af,af'
			push	bc
			bit	4,(ix+SP_STATE)
			jp	nz,esta_jumpcar		;Don't check if the car didn't run
			ld	a,(ix+SP_COLOR)		;Get color
			xor	131			;Real color, add attribute bit for message
			ld	(mes_mt_color),a	;Set color for timestamp message
			ld	(mes_points_col),a	;Set color for points message
			ld	h,(ix+SP_TIMESTAMP)
			ld	l,(ix+SP_TIMESTAMP+1)	;Get timestamp (total time)
			call	timeprint3		;Print it in timestamp message
			push	de			;Keep position
			ld	bc,mes_mt_color		
			call	printmessage		;Print total time timestamp
			pop	de			;Restore position
			ld	a,13
			add	a,e
			ld	e,a			;Update position for next timestamp
			ld	h,(ix+SP_BESTLAP)
			ld	l,(ix+SP_BESTLAP+1)	;Get timestamp (best lap)
			push	hl			;Keep it
			call	timeprint3		;Print it in timestamp message
			push	de			;Keep position
			ld	bc,mes_mt_color		
			call	printmessage		;Print best lap timestamp
			pop	de			;Restore position
			ld	a,12
			add	a,e
			ld	e,a			;Update position for points
			ld	a,(ix+SP_MAPPOINTS)
			add	a,16
			ld	(mes_points),a		;Set points in points message
			pop	bc			;Get best lap for this car
			ld	hl,(bestlap)
			sbc	hl,bc			;Compare with total best lap
			jr	nz,esta_nobestlap
			ld	a,CHR_PLUS		;If we have the best lap, add the extra points
			ld	(mes_extrapoints),a	;Set plus sign
			ld	a,(tablepointsbl)
			add	a,16
			ld	(mes_extrapoints+1),a	;Set the best lap points
			ld	a,(tablepointsbl)
			add	a,(ix+SP_POINTS)
			ld	(ix+SP_POINTS),a	;Add to total points of this track
			ex	af,af'
			scf				;Set carry flag in F'
			ex	af,af'
			jr	esta_printpoints
esta_nobestlap:		ld	a,CHR_SPACE		;If we don't have the best lap
			ld	(mes_extrapoints),a
			ld	(mes_extrapoints+1),a	;Set spaces in the last two chars
esta_printpoints:	push	de			;Keep position
			ld	bc,mes_points_col
			call	printmessage		;Print points message
			pop	de			;Restore position
			ld	a,7
			add	a,e
			ld	e,a			;Update position for next line
			ld	a,(ix+SP_MAPPOINTS)
			add	a,(ix+SP_POINTS)
			ld	(ix+SP_POINTS),a	;Update total points with points given by position in track
esta_jumpcar:		ex	af,af'			;A' (now A) has the records byte
			rla				;Enter bit telling if it has the record or not
			bit	7,(ix+SP_STATE)		;Check human bit
			jr	z,esta_nothuman
			add	a,16			;Set human bit if needed
esta_nothuman:		ex	af,af'			;Keep the records byte in A' again
			ld	bc,car2-car1
			add	ix,bc			;Point to next car
			pop	bc
			dec	b
			jp	nz,esta_extloop		;Loop for all cars

			ld	a,(currentmap2)		;Get current map*2
			add	a,a
			add	a,a
			add	a,a			;*8
			ld	e,a
			ld	a,(mode)
			add	a,e			;Add category
			ld	e,a
			ld	d,0
			ld	ix,mapas+2
			ld	iy,mapas+6
			add	ix,de			;0 -> points to record holders
			ld	a,(mode)
			add	a,e			;Add category again
			ld	e,a
			add	iy,de			;0,1 -> points to record

			ld	d,(iy+0)
			ld	e,(iy+1)		;DE=old record
			ld	hl,(bestlap)
;			and	a			;No carry since the last "add iy,de"
			sbc	hl,de
			jr	nc,esta_nonewrecord
			add	hl,de			;A new record has been made
			ld	(iy+0),h
			ld	(iy+1),l		;Set new record
			ex	af,af'
			ld	(ix+0),a		;Set new record holders

esta_nonewrecord:	ld	ix,car1			;IX points to first car
			ld	c,4			;4 cars
			ld	de,car2-car1
esta_outerposition:	ld	b,4			;4 cars, initial position
			ld	(ix+SP_MAPPOINTS),b	;Set position 4 for IX's car
			ld	iy,car1			;IY points to first car
esta_innerposition:	ld	a,(ix+SP_POINTS)
			cp	(iy+SP_POINTS)		;Compare points for next car
			jr	c,esta_nodecpos
			dec	(ix+SP_MAPPOINTS)	;Decrease position if the other car has more points
esta_nodecpos:		add	iy,de			;IY points to next car
			djnz	esta_innerposition	;Loop all cars pointed by IY
			add	ix,de			;IX points to next car
			dec	c
			jr	nz,esta_outerposition	;Loop all cars

			ld	hl,tr_col1		;Position of 1st classified (so far) color code
			ld	c,0			;Position to look for
esta_outerposition2:	ld	b,4			;Number of cars
			ld	ix,car1			;Point to first car
esta_innerposition2:	push	bc
			ld	a,c
			cp	(ix+SP_MAPPOINTS)		;Check position
			jr	nz,esta_dontprintpointshere	;Don't do anything if it's not the one we're looking for
                        bit     4,(ix+SP_STATE)			;Check if the cars runs
                        jr      nz,esta_dontprintpointshere	;Don't do anything if the car didn't run
			ld	a,(ix+SP_COLOR)		;Get color
			xor	131			;Real color, add attribute bit for message
			ld	(hl),a			;Set color in results so far message
			inc	hl
			inc	hl			;Point to position
			ld	a,c
			add	a,17			;Transform position into number character
			ld	(hl),a			;Set position character
			inc	hl
			inc	hl
			inc	hl
			inc	hl			;Point to points
			ld	a,(ix+SP_POINTS)
			ld	b,15			;0 character minus 1
esta_mod10:		inc	b			;Increase tens digit
			sub	10			;Substract 10
			jr	nc,esta_mod10		;Keep increasing it while score > 0
			add	a,26			;Revert back the last substraction, and add the constant to form character
			ld	(hl),b			;Store first digit
			inc	hl
			ld	(hl),a			;Store second digit
			inc	hl
			inc	hl
			inc	hl			;Point to next line
esta_dontprintpointshere:
			pop	bc
			add	ix,de			;Point to next car
			djnz	esta_innerposition2	;Loop for all cars
			inc	c			;Next position to check
                        ld      a,(nactive_cars+1)
                        cp      c			;Check against number of cars
                        jr      nz,esta_outerposition2	;Loop while there are cars
                        cp      4			;position 4 reached?
                        jr      z,esta_nomoreclass	;Yes: no more lines to process
                        ld	a,128			; No: Black color
                        ld      (tr_col4),a		;     for the fourth line
                        ld      a,c
                        cp      2			;Only two cars?
                        jr      nz,esta_nomoreclass	; No: no more lines to process
                        ld	a,128			;Yes: Black color
                        ld      (hl),a			;     for the third line too
esta_nomoreclass:       ld      bc,tr_trackres		;Message for total results so far
			call	printmessage		;Print it
			ld	a,(is128k)
			and	a
			jr	z,esta_48k		;48?
			ld	bc,message_replay	;No: Message including "R to Replay"
			call	printmessage
			call	wait_nokey		;Wait for no key to be pressed
			call    wait_key		;Wait for a key to be pressed
			halt
			call	silencia_ay
			ld	a,(key_t_q)		;Get semirow
			and	8			;Check for key R
			jp	z,doreplay		;If pressed, do replay
			jr	esta_128k

esta_48k:		ld	bc,tr_presskey		;Message without the "R to Replay" part
			call	printmessage
			call	wait_nokey		;Wait for no key to be pressed
			call    wait_key		;Wait for a key to be pressed
esta_128k:		ld	a,(currentmap)
			inc	a
			ld	(currentmap),a		;Update current map
			cp	8
			jp	c,start_stage		;Start next stage if we haven't reached 8

;********
;endgame: Show the end of the game, with the pilots on the podium
;********
endgame:		ld	a,(is128k)
			and	a
			jr	z,endgame48
			ld	h,4			;If we're in 128k, load song 4
			call	load_wyz
endgame48:		ld	hl,menulogo
			di
			call	deexo_screen		;Uncompress the logo screen
			ei
			ld	bc,end_podium
			call	printmessage		;Print end message and podium

			ld	hl,endg_n1
			ld	de,car2-car1
			ld	c,0			;Test for number 1
endg_loopcount_out:	ld	b,4			;Number of cars
			xor	a
			ld	(hl),a			;Reset number of cars found with the testing position
			ld	ix,car1			;First car
endg_loopcount_inn:	bit	4,(ix+SP_STATE)
			jp	nz,endg_loopcount_end	;Don't check if the car doesn't race
			ld	a,c
			cp	(ix+SP_MAPPOINTS)	;MAPPOINTS holds the position
			jr	nz,endg_loopcount_end
			inc	(hl)			;If found, increase number of occurences
endg_loopcount_end:	add	ix,de			;Point to next car
			djnz	endg_loopcount_inn
			inc	c			;Next position to be checked
			inc	hl
			inc	hl			;Point to next podium position
			ld	a,c
			cp	3
			jr	nz,endg_loopcount_out	;Keep looping until we reach position 3

			ld	c,0			;Test for number 1
			ld	iy,endg_n1		;Number one position and number of occurences
endg_loopprint_out:	ld	b,4
			ld	a,(iy+1)		;Get position offset
			sub	(iy)			;Substract number of occurences to get the real position
			ld	l,a			;Keep in L

			ld	ix,car1			;First car
endg_loopprint_inn:	bit	4,(ix+SP_STATE)
			jp	nz,endg_loopprint_end	;Don't check if the car doesn't race
			ld	a,c
			cp	(ix+SP_MAPPOINTS)	;MAPPOINTS holds the position
			jr	nz,endg_loopprint_end
			ld	a,l			;Get position
			ld	(end_pilotp1),a		;Store first line of pilot position
			add	a,32
			ld	(end_pilotp2),a		;Store second line of pilot position
			add	a,32
			ld	(end_pilotp3),a		;Store third line of pilot position
			add	a,32
			ld	(end_pilotp4),a		;Store fourth line of pilot position
			sub	94
			ld	l,a			;HL now points to next position
			ld	a,(ix+SP_COLOR)		;Get car color XOR 3
			xor	131			;Get the real color, add attribute bit for message
			ld	(end_pilotc3a),a	;Paint the pilot body, upper left char
			ld	(end_pilotc4a),a	;Paint the pilot body, lower left char
			xor	64			;Bright
			ld	(end_pilotc3b),a	;Paint the pilot body, upper right char
			ld	(end_pilotc4b),a	;Paint the pilot body, lower right char
			push	bc			;Keep counter
			push	hl
			ld	bc,end_pilot
			call	printmessage		;Print pilot
			pop	hl
			pop	bc			;Restore counter
endg_loopprint_end:	ld	de,car2-car1
			add	ix,de			;Point to next car
			djnz	endg_loopprint_inn	;Keep printing all pilots
			inc	c			;Next position to be checked
			inc	iy
			inc	iy			;Point to next position
			ld	a,c
			cp	3
			jr	nz,endg_loopprint_out	;Keep looping until we reach position 3

			;call	printmessage

			call	micropause		;Do a small pause
			call	wait_nokey		;Wait for no keys to be pressed
			call	wait_key		;Wait for a key to be pressed
			ld	a,(is128k)
			and	a
			jr	z,endg_tomenu		;If we're in 48k, let's go
			ld	a,3			;If we're in 128k, set bank 3
			call	setbank		
			call	49152			;Call the special images routine
			call	setbank0		;Set bank 0 again
endg_tomenu:		jp	menu			;Back to menu




							;main_cars loop continues here

main_restart:		ld	bc,(main_ticks)
			ld	(ix+SP_LAPSTART+0),b
			ld	(ix+SP_LAPSTART+1),c	;Keep the start time for the next lap
	
main_nocheck:		ld	de,car2-car1
			add	ix,de			;IX points to the next car
			pop	bc			;Restore BC
			dec	b			;If there are more cars left
			jp	nz,main_cars		;Continue loop

							;End main_cars loop
			

			ld	a,(minimap_cycle)
			inc	a
			and	7
			ld	(minimap_cycle),a	;Update minimap cycle variable
	
							;Reset relative positions
			ld	a,1
			ld	(car1+SP_RELPOS),a
			ld	(car2+SP_RELPOS),a
			ld	(car3+SP_RELPOS),a
			ld	(car4+SP_RELPOS),a
	
							;Check if there is any collision, and recreate relative positions
			ld	ix,car1
			ld	iy,car2
			call	checkcollision		;Check for collisions & set position between cars 1 and 2
			ld	iyl,car3%256
			call	checkcollision		;Check for collisions & set position between cars 1 and 3
			ld	iyl,car4%256
			call	checkcollision		;Check for collisions & set position between cars 1 and 4
			ld	ixl,car3%256
			call	checkcollision		;Check for collisions & set position between cars 3 and 4
			ld	ixl,car2%256
			call	checkcollision		;Check for collisions & set position between cars 2 and 4
			ld	iyl,car3%256
			call	checkcollision		;Check for collisions & set position between cars 2 and 3

			ld	iy,camera_left		;Select left camera
			ld	a,(extra_keys)
			and	2
			call	z,switchcar		;If the CAM 1 key is pressed, switch car at the left half
			ld	a,(iy+CAM_CAR)
			ld	(other),a

halt1:			ld	a,(fastforward)
			cp	4
			jr	z,nofastfowardleft
			and	a
			jr	nz,fastfowardleft	;If fastforward variable is not 0 or 4, jump left screen update
			
nofastfowardleft:	call	tohaltwithsound		;Wait the raster retraze and make beeper sound
			call	volcarmapa		;Dump the left map
			call	printbg			;Paint the left background in the buffer
			call	printcars		;Paint the left cars in the buffer
			call	dump_left		;Dump the buffer to left screen (CEZBlocks)

fastfowardleft:		ld	iy,camera_right		;Select right camera
			ld	a,(extra_keys)
			and	1
			call	z,switchcar		;If the CAM 2 key is pressed, switch car at the right half
			ld	a,(iy+CAM_CAR)
			ld	(other),a

halt2:			ld	a,(extra_keys)
			and	8
			call	z,pause			;If the PAUSE key is pressed, call the pause procedure

			ld	a,(fastforward)
			cp	8
			jr	z,nofastforwardright
			and	a
			jr	nz,fastforwardright	;If fastforward variable is not 0 or 8, jump right screen update
			
nofastforwardright:	call	tohaltwithsound		;Wait the raster retraze and make beeper sound
			call	volcarmapa		;Dump the right map
			call	printbg			;Paint the right background in the buffer
			call	printcars		;Paint the right cars in the buffer
			
			
			push	bc			;Small delay to avoid tearing at right part
			ld	b,255
diley:			djnz	diley
			ld	b,155
diley2:			djnz	diley2		
			pop	bc
			
			call	dump_right		;Dump the buffer to right screen (CEZBlocks)


halt3:			;call	tohaltwithsound
			halt				;Halt again
fastforwardright:	ld	a,(fastforward)
			and	a
			jr	z,notfastforwarding
			dec	a			;If we're fastforwarding, update the fastforward variable
			jr	nz,norecharge
			ld	a,10
norecharge:		ld	(fastforward),a
notfastforwarding:	ld	hl,(main_ticks)		;Get main time
			ld	iy,message_clock-CAM_MESSTIME
			call	timeprint		;Print it
			ld	bc,message_clock
			call	printmessage		;Print the clock time
			ld	bc,camera_left+CAM_MESSTIME
			call	printmessage		;Print the left camera time
			ld	bc,camera_right+CAM_MESSTIME
			call	printmessage		;Print the right camera time

			ld	hl,(main_ticks)
			inc	hl
			ld	(main_ticks),hl			;Update ticks counter

			ld	a,(changemarker)		
			and	a				;Is there a need to change the marker?
			jp	z,mainloop			;  No: Go back to the main loop
								;  prepare the marker
			cp	3
			jr	nz,mark_nofirstmessage
			ld	a,(recording)			;If value is 3, we need to print the first mesage
			cp	2				;Are we replaying?
			ld	bc,mfirst_play
			jr	nz,mark_firstmessage		;  No: go to print the first play message
			ld	bc,mfirst_replay		;  Yes: go to print the first replay message
mark_firstmessage:	call	printmessage			
			ld	bc,mfirst_all			;Common part to first messages
			call	printthemarker2			;Print it
			jp	mainloop			;Repeat the main loop
mark_nofirstmessage:	dec	a				
			jr	nz,doprintthemarker		;If value was 1, go to print the marker
			call	preparemarker			;If value was 2, prepare the marker
			jp	mainloop			;Repeat the main loop
doprintthemarker:	call	printthemarker			;Print the marker
			jp	mainloop			;Repeat the main loop

;**************
;preparemarker: Prepare the marker to be updated on next frame.
;**************
preparemarker:		ld	ix,2*car1-car2		;First car address minus the lenght of its variables space
			ld	de,car2-car1
mark_buc1:		add	ix,de			;Point to next car
			ld	a,(ix+SP_RELPOS)
			cp	4
			jr	nz,mark_buc1		;Keep looking until we find the first position
			ld	a,(ix+SP_COLOR)
			xor	131			;Real color, add attribute bit for message
			ld	(message_col1st),a	;Set color
			ld	de,message_col1st+2	;Fixed position

			ld	hl,mes_mark_1st		;HL points to "WINNER"
			bit	2,(ix+SP_STATE)		;Check if we've finished
			jr	nz,mark_winner1		;Finished: Go to print HL's message.
			
							;Not finished yet: print current lap and checkpoint
			ld	a,(ix+SP_TIMESTAMPLAP)	;Get lap of the last timestamp
			add	a,16			;Turn into character
			ld	(mes_ml_lap),a		;Store lap in message
			ld	a,(ix+SP_TIMESTAMPCP)	;Get checkpoint
			rlca
			rlca
			rlca				;Divide by 8
			and	7			;Keep only 3 bits
			add	a,16			;Turn into character
			ld	(mes_ml_ch1),a		;Store checkpoint number
			ld	hl,mes_mark_lapch	;HL points to Lx-CHy message
mark_winner1:		ld	bc,6
			ldir				;Print first message (WINNER/Lx-CHY)
			inc	de			;Point to next mark_message writing position
			push	ix			;Store last car variables address
			pop	iy			;Last car variables address in IY now
			push	de
			ld	ix,2*car1-car2		;First car address minus the lenght of its variables space
			ld	de,car2-car1
mark_buc2:		add	ix,de			;Point to next car
			ld	a,(ix+SP_RELPOS)	
			cp	3			;Look for second position now
			jr	nz,mark_buc2
			pop	de			;DE=mark_message writing position here
		
			ld	a,(ix+SP_TIMESTAMPLAP)
			cp	(iy+SP_TIMESTAMPLAP)	;lap number different between first and second?
			jr	nz,mark_separate2	;Yes -> go to print a separation line between them

			ld	a,(ix+SP_TIMESTAMPCP)	;No ->
			cp	(iy+SP_TIMESTAMPCP)	;  checkpoint number different between first and second?
			jr	nz,mark_separate2	;  Yes -> go to print a separation line between them
							;  No -> print the difference

			ld	a,32*2+17		
			ld	(de),a			;Place second car's line into line 2 of marker
			inc	de			;Now point to attribute byte
			
			ld	a,32*7+17
			ld	(message_black1),a 	;Black color in 7th row

			ld	a,(ix+SP_COLOR)		;Get color for second car
			xor	131			;Real color
			ld	(de),a			;Set color position
			inc	de			
			inc	de			;Point to characters for second car

			ld	hl,mes_mark_2nd		;HL points to "SECOND"
			bit	2,(ix+SP_STATE)		;Check if we've finished
			jr	nz,mark_winner2		;Finished: Go to print HL's message
							;Not finished: print time difference

			ld	h,(ix+SP_TIMESTAMP)
			ld	l,(ix+SP_TIMESTAMP+1)	;Get second car's timestamp
			ld	b,(iy+SP_TIMESTAMP)
			ld	c,(iy+SP_TIMESTAMP+1)	;Get first car's timestamp
			sbc	hl,bc			;Get the difference
			call	timeprint2		;Print it
			jr	mark_winner2		;Continue with third car

mark_separate2:		ld	a,32*2+17
			ld	(message_black1),a 	;Black in second row

			ld	a,32*3+17
			ld	(de),a			;Second car's line in 3rd marker row
			inc	de			;Point to color

			ld	a,(ix+SP_COLOR)
			xor	131			;Real color, add attribute bit for message
			ld	(de),a			;Set color
			inc	de
			inc	de			;Point to message
			push	de

			ld	a,(ix+SP_TIMESTAMPLAP)	;Get lap of the last timestamp
			add	a,16			;Turn into character
			ld	(mes_ml_lap),a		;Store lap in message
			ld	a,(ix+SP_TIMESTAMPCP)	;Get checkpoint
			rlca
			rlca
			rlca				;Divide by 8
			and	7			;Keep only 3 bits
			add	a,16			;Turn into character
			ld	(mes_ml_ch1),a		;Store checkpoint in message
			ld	hl,mes_mark_lapch	;HL points to Lx-CHy message
			push	ix
			pop	iy			;Now the second car is pointed by IY
			pop	de
mark_winner2:		ld	bc,6
			ldir				;Print second message (SECOND/Lx-CHY/+x:yy.z)

			inc	de			;Point to third car's line
			push	de
			ld	ix,2*car1-car2		;First car address minus the lenght of its variables space
			ld	de,car2-car1
mark_buc3:		add	ix,de			;Point to next car
			ld	a,(ix+SP_RELPOS)
			cp	2			;Third?
			jr	nz,mark_buc3
			pop	de

			ld	a,(ix+SP_TIMESTAMPLAP)
			cp	(iy+SP_TIMESTAMPLAP)	;lap number different between second and third?
			jr	nz,mark_separate3	;Yes -> go to print a separation line between them

			ld	a,(ix+SP_TIMESTAMPCP)	;No ->
			cp	(iy+SP_TIMESTAMPCP)	;  checkpoint number different between first and second?
			jr	nz,mark_separate3	;  Yes -> go to print a separation line between them
							;  No -> print the difference
			
			ld	a,(message_pos2nd)	;Get second car's line position
			add	a,32			
			ld	(de),a			;Set third car's line position in next line
			inc	de
			add	a,96
			ld	(message_black2),a	;Black line 3 lines below the third's

			ld	a,(ix+SP_COLOR)		;Get color
			xor	131			;Real color, add attribute bit for message
			ld	(de),a			;Set color
			inc	de
			inc	de			;Point to message

			ld	hl,mes_mark_3rd		;HL points to "THIRD "
			bit	2,(ix+SP_STATE)
			jr	nz,mark_winner3		;Print it if it has already arrived
			ld	h,(ix+SP_TIMESTAMP)
			ld	l,(ix+SP_TIMESTAMP+1)	;Get third car's timestamp
			ld	b,(iy+SP_TIMESTAMP)
			ld	c,(iy+SP_TIMESTAMP+1)	;Get second car's timestamp
			sbc	hl,bc			;Get the difference
			call	timeprint2		;Print it in message
			jr	mark_winner3		;Keep processing

mark_separate3:		ld	a,(message_pos2nd)	;Get second's car line position
			add	a,32
			ld	(message_black2),a	;Black color one line below
			add	a,32
			ld	(de),a			;And third car's line another below
			inc	de			;Point to color

			ld	a,(ix+SP_COLOR)		;Get color
			xor	131			;Real color, add attribute bit for message
			ld	(de),a			;Set color
			inc	de
			inc	de			;Point to message
			push	de

			ld	a,(ix+SP_TIMESTAMPLAP)	;Get lap of the last timestamp
			add	a,16			;Turn into character
			ld	(mes_ml_lap),a		;Store lap in message
			ld	a,(ix+SP_TIMESTAMPCP)	;Get checkpoint of the last timestamp
			rlca
			rlca
			rlca				;Divide by 8
			and	7			;Keep only 3 bits
			add	a,16			;Turn into character
			ld	(mes_ml_ch1),a		;Store checkpoint in message
			ld	hl,mes_mark_lapch	;HL points to Lx-CHy message
			push	ix
			pop	iy			;IY = IX = third car
			pop	de
mark_winner3:		ld	bc,6
			ldir				;Print third message (THIRD /Lx-CHY/+x:yy.z)
			inc	de			;Point to next one

			push	de
			ld	ix,2*car1-car2		;First car address minus the lenght of its variables space
			ld	de,car2-car1
mark_buc4:		add	ix,de			;Point to next car
			ld	a,(ix+SP_RELPOS)
			cp	1			;Look for the fourth car
			jr	nz,mark_buc4
			pop	de
		
			ld	a,(ix+SP_TIMESTAMPLAP)
			cp	(iy+SP_TIMESTAMPLAP)	;lap number different between third and fourth?
			jr	nz,mark_separate4	;Yes -> go to print a separation line between them
			ld	a,(ix+SP_TIMESTAMPCP)	;No ->
			cp	(iy+SP_TIMESTAMPCP)	;  checkpoint number different between first and second?
			jr	nz,mark_separate4	;  Yes -> go to print a separation line between them
							;  No -> print the difference

			ld	a,(message_pos3rd)	;Get third car's line position
			add	a,32
			ld	(de),a			;Set fourth car's line position in next line
			inc	de
			add	a,32
			ld	(message_black3),a	;Black line 1 lines below the fourth's

			ld	a,(ix+SP_COLOR)		;Get color
			xor	131			;Real color, add attribute bit for message
			ld	(de),a			;Set color position
			inc	de
			inc	de			;Point to message

			ld	hl,mes_mark_4th		;HL points to "LOSER!"
			bit	2,(ix+SP_STATE)
			jr	nz,mark_winner4		;Print it if it has already arrived

			ld	h,(ix+SP_TIMESTAMP)
			ld	l,(ix+SP_TIMESTAMP+1)	;Get fourth car's timestamp
			ld	b,(iy+SP_TIMESTAMP)
			ld	c,(iy+SP_TIMESTAMP+1)	;Get third car's timestamp
			sbc	hl,bc			;Get the difference
			call	timeprint2		;Print it in message
			jr	mark_winner4		;Keep processing

mark_separate4:		ld	a,(message_pos3rd)	;Get third's car line position
			add	a,32
			ld	(message_black3),a	;Black color one line below
			add	a,32
			ld	(de),a			;And fourth car's line another below
			inc	de			;Point to color

			ld	a,(ix+SP_COLOR)		;Get color
			xor	131			;Real color, add attribute bit for message
			ld	(de),a			;Set color
			inc	de
			inc	de			;Point to message
			push	de
		
			ld	a,(ix+SP_TIMESTAMPLAP)	;Get lap of the last timestamp
			add	a,16			;Turn into character
			ld	(mes_ml_lap),a		;Store lap in message
			ld	a,(ix+SP_TIMESTAMPCP)	;Get checkpoint of the last timestamp
			rlca
			rlca
			rlca				;Divide by 8
			and	7			;Keep only 3 bits
			add	a,16			;Turn into character
			ld	(mes_ml_ch1),a		;Store checkpoint in message
			ld	hl,mes_mark_lapch	;HL points to Lx-CHy message

			pop	de
mark_winner4:		ld	bc,6
			ldir				;Print fourth message (LOSER!/Lx-CHY/+x:yy.z)

			ld	a,2
			ld	(changemarker),a	;Signal that marker should be printed next frame
			ret

;***************
;printthemarker: Print the marker
;***************
printthemarker:		ld	bc,marker_message	;Marker message
printthemarker2:	call	printmessage		;Print it
			xor	a
			ld	(changemarker),a	;No need to print it again next main loop
			ret

;***************
;checkcollision: Test which car goes before the other, and check if they collide
;***************
;IX points to one car, IY points to another
checkcollision:		ld	a,(ix+SP_TIMESTAMPLAP)
			cp	(iy+SP_TIMESTAMPLAP)
			jr	c,iyhigher
			jr	nz,ixhigher		;Compare number of laps. The highest is placed before.
			ld	a,(ix+SP_TIMESTAMPCP)
			cp	(iy+SP_TIMESTAMPCP)
			jr	c,iyhigher
			jr	nz,ixhigher		;Compare checkpoint. The highest is placed before.
			ld	a,(ix+SP_TIMESTAMP)
			cp	(iy+SP_TIMESTAMP)
			jr	c,ixhigher
			jr	nz,iyhigher		;Compare timestamp (high). The lowest is placed before.
			ld	a,(ix+SP_TIMESTAMP+1)
			cp	(iy+SP_TIMESTAMP+1)
			jr	c,ixhigher
			jr	nz,iyhigher		;Compare timestamp (low). The lowest is placed before.
			ld	a,(ix+SP_COLOR)
			cp	(iy+SP_COLOR)
			jr	c,ixhigher		;Compare color. Fixed order magenta->blue->yellow->cyan
iyhigher:		inc	(iy+SP_RELPOS)		;Increase relative position of the car pointed by IY
			jr	donepositioning
ixhigher:		inc	(ix+SP_RELPOS)		;Increase relative position of the car pointed by IX
donepositioning:	ld	a,(ix+SP_STATE)
			and	(iy+SP_STATE)
			and	2
			ret	nz			;Don't check if they're both already colliding

			bit	4,(ix+SP_STATE)
			ret	nz			;Exit if first car is inactive

			bit	4,(iy+SP_STATE)
			ret	nz			;Exit if second car is inactive

			ld	a,(ix+SP_MAPY)
			sub	(iy+SP_MAPY)		;Compare vertical map positions
			jr	c,cc_negatifo_y
			cp	2			;Check positive value (IY car above IX car)
			jr	c,cc_noextrem_y
			cp	63
			ret	nz			;Exit if vertical positions are far
			sub	64
			jr	cc_noextrem_y
cc_negatifo_y:		cp	-2			;Check negative value (IY car below IX car)
			jr	nc,cc_noextrem_y
			cp	-63
			ret	nz			;Exit if vertical positions are far
			add	a,64
cc_noextrem_y:		add	a,a			;Vertical position is near
			add	a,a
			add	a,a
			add	a,(ix+SP_INTRAY)
			sub	(iy+SP_INTRAY)		;Calculate vertical distance in characters
			add	a,2			;Add 2, now the range we're looking for (-2 to 2) becomes (0 to 4)
			cp	5			
			ret	nc			;No collision if we're not in the range
			ld	e,a
			add	a,a
			add	a,a
			add	a,e
			ld	e,a			;E=(diffY+2)*5

			ld	a,(ix+SP_MAPX)
			sub	(iy+SP_MAPX)		;Compare horizontal map positions
			jr	c,cc_negatifo_x
			cp	2			;Check positive value (IY car to the left of IX car)
			jr	c,cc_noextrem_x
			cp	63
			ret	nz			;Exit if horizontal positions are far
			sub	64
			jr	cc_noextrem_x
cc_negatifo_x:		cp	-2			;Check negative value (IY car to the right of IX car)
			jr	nc,cc_noextrem_x
			cp	-63
			ret	nz			;Exit if horizontal positions are far
			add	a,64
cc_noextrem_x:		add	a,a			;Horizontal position is near
			add	a,a
			add	a,a
			add	a,(ix+SP_INTRAX)	;Calculate horizontal distance in characters
			sub	(iy+SP_INTRAX)		;Add 2, now the range we're looking for (-2 to 2) becomes (0 to 4)
			add	a,2
			cp	5		
			ret	nc			;No collision if we're not in the range
			add	a,e			;A = (diffX+2)+((diffY+2)*5)
			or	128			;Add 128
			ld	e,a
			ld	d,tablagiros/256	;DE = colis2[diffy][diffx]
			ld	a,(de)			;Take value from table "colis2" (25 values)
			rr	a			;Get first bit starting from the right
			jr	z,cc_crash		;If there was a 0 in the table, there's a collision for sure, no need to keep checking
			ld	(cc_checkit+1),a	;Self-modifying code BIT n,(hl)
			jr	nc,cc_noswapped		;If the bit is 0, no need to swap positions when comparing the cars
			ld	a,(iy+SP_FRAME)
			rla
			rla
			rla
			and	240			;Put the direction (bits 4-1 of frame) of car pointed by IY into bits 7-4
			ld	l,a			;Keep in register L
			ld	a,(ix+SP_FRAME)	
			jr	cc_continue
cc_noswapped:		ld	a,(ix+SP_FRAME)
			rla
			rla
			rla
			and	240			;Put the direction (bits 4-1 of frame) of car pointed by IX into bits 7-4
			ld	l,a			;Keep in register L
			ld	a,(iy+SP_FRAME)
cc_continue:		rra	
			and	15			;Put the direction (bits 4-1 of frame) of the other car into bits 3-0
			add	a,l			;Join both
			ld	l,a
			ld	h,colisiones/256	;Form address in table
cc_checkit:		bit	0,(hl)			;Check bit in the table
			ret	z			;Return if there's no collision

							;There's been a new collision!
cc_crash:		ld	a,25
			add	a,e
			ld	e,a
			ld	a,(de)			;Read from table colis3
			ld	d,0
			rra				;Get the rightmost bit
			jr	c,cc_swappedro		;If it's 1, let's swap the rotation
			ld	(ix+SP_COL_DIR),d
			inc	d
			ld	(iy+SP_COL_DIR),d
			dec	d
			jr	cc_noswappedro
cc_swappedro:		ld	(iy+SP_COL_DIR),d
			inc	d
			ld	(ix+SP_COL_DIR),d
			dec	d
cc_noswappedro:		rra				;Get another bit
			jr	nc,cc_norandomcra	;If no carry, the crash won't be random
			ld	a,(recording)
			cp	2
			jr	nz,cc_getrandom		
			call	rec_get4bits		;If we're replaying, get the random number from the record stream
			ld	a,c
			jr	cc_norandomcra
cc_getrandom:		ld	a,r			;Read random number
			and	15			;Get 4 bits
			ld	c,a
			call	setrec4bits		;Store in the recording stream
			ld	a,c
cc_norandomcra:		ld	e,a

			ld	hl,speeds
			add	hl,de
			ld	e,(hl)			;e=CRASH_DIRX
			ld	a,l
			sub	4
			ld	l,a
			ld	l,(hl)			;l=CRASH_DIRY

			ld	d,(ix+SP_DIRX)		;d=CAR1_DIRX
			ld	h,(iy+SP_DIRX)		;h=CAR2_DIRX
			ld	a,h
			add	a,e
			sra	a
			add	a,d
			sra	a
			add	a,e
			sra	a
			ld	(ix+SP_DIRX),a		;NEW CAR1_DIRX
			ld	a,d
			sub	e
			sra	a
			add	a,h
			sra	a
			sub	e
			sra	a
			ld	(iy+SP_DIRX),a		;NEW CAR2_DIRX
			ld	d,(ix+SP_DIRY)		;d=CAR1_DIRY
			ld	h,(iy+SP_DIRY)		;d=CAR2_DIRY
			ld	a,h
			add	a,l
			sra	a
			add	a,d
			sra	a
			add	a,l
			sra	a
			ld	(ix+SP_DIRY),a		;NEW CAR1_DIRY
			ld	a,d
			sub	l
			sra	a
			add	a,h
			sra	a
			sub	l
			sra	a
			ld	(iy+SP_DIRY),a		;NEW CAR2_DIRY
							;Directions are done

			ld	a,(ix+SP_COL_DUR)
			sra	a
			add	a,(ix+SP_SPEED)
			add	a,3
			ld	(ix+SP_SPEED),a		;Set speed for first car
			add	a,(iy+SP_SPEED)
			ld	e,a
			add	a,(ix+SP_SPEED)
			rra
			ld	(ix+SP_COL_DUR),a	;Set crash duration for first car

			ld	a,(iy+SP_COL_DUR)
			sra	a
			add	a,(iy+SP_SPEED)
			add	a,3
			ld	(iy+SP_SPEED),a		;Set speed for second car
			add	a,e
			rra
			ld	(iy+SP_COL_DUR),a	;Set crash duration for second car
			ld	a,(ix+SP_STATE)
			or	2
			ld	(ix+SP_STATE),a		;Set crash bit in state of first car
			ld	a,(iy+SP_STATE)
			or	2
			ld	(iy+SP_STATE),a		;Set crash bit in state of second car
			ret

;********
;control: Main control routine, checks the car's current state, and calls to its control routine if necessary
;********
control:		call	get_attr_self		;Get what we're standing on
			cp	64			;Over 64?
			jr	c,cont_nosemih		;  No: We're not on a bright zone
							;  Yes: We're over the stripes, so car is half over the grass
			ld	a,(recording)		
			cp	2			
			jr	nz,control_randhie
			call	rec_getbit		;If we're replaying, read a bit from the recording stream
			jr	nc,cont_rechier		;Bit 0: slowdown
			jp	cont_nohierba		;Bit 1: no slowdown
control_randhie:	ld	a,r			;Get random number
			and	127			;Don't take high bit into consideration
			cp	85
			jp	c,cont_nohierba2	;Under 85 > no slowdown
			call	setrec0			;Over 84: slowdown > Set a 0 bit in the recording stream
cont_rechier:		ld	a,(ix+SP_SPEED)		;Get speed
			dec	a			;Decrease it
			jp	m,cont_nohierba		;No real effect if speeds turns negative after that decrement
			jr	cont_parado		;Slow down if it doesn't

cont_nohierba2: 	call    setrec1			;Set a 1 bit in the recording stream
                	jp      cont_nohierba		;And no effect

cont_nohierba3: 	call    setrec0			;Set a 0 bit in the recording stream
                	ld      a,l			;Original speed
                	jp      cont_nohierba		;No slowdown

cont_nosemih:		and	56			;Isolate paper bits
			cp	32			;Check if we're on grass
			ld	a,(ix+SP_STATE)		;Get state
			jr	z,cont_enlahierba
			and	254			;Erase grass bit from state
			ld	(ix+SP_STATE),a		;Update state
			jr	cont_nohierba
cont_enlahierba:	or	1			;We're on grass, set grass bit in state
			ld	(ix+SP_STATE),a		;Update state
			and	2
			jr	nz,cont_nohierba	;Don't slow down if we're crashing
			ld	a,(ix+SP_SPEED)		;Get speed
			and	a			;Check it
			jr	z,cont_nohierba		;Don't slow down if we're stopped
			ld	l,a			;Keep speed in register L
			dec	a			;Decrease it
			cp	2
			jr	z,cont_parado		;If it's 2, apply the slow down
			jr	nc,cont_sub1		
							;Speed is 1
			ld	a,(recording)
			cp	2
			jr	nz,cont_rand_enla2
			call	rec_getbit		;If we're replaying, read a bit from the recording stream
			ld	a,l			;Get original speed
			jr	nc,cont_nohierba	;No slowdown if bit was 0
                	jp      cont_sub1		;Slowdown if bit was 1
cont_rand_enla2:	ld      a,r			;Get random number
                	and     127
                	cp      45			;Over 44?
                	ld      a,l			;Get original speed
                	jr      nc,cont_nohierba3	;Over 44 > no slowdown
                					;Under 45
                	call    setrec1			;Set a 1 bit in the recording stream
                	ld      a,l			;Original speed
cont_sub1:		dec	a			;Decrease speed

cont_parado:		ld	(ix+SP_SPEED),a		;Update speed

cont_nohierba:		ld	a,(ix+SP_STATE)		;Get state
			ld	l,a			;Keep it in register L
			and	2			;Check bit 2 (crash)
			ld	a,l			;Restore state in A
			jr	nz,cont_crashcontrol	;If we're crashing, you're not in control
			and	4			;Check bit 4 (finished)
			jr	nz,cont_wincontrol	;If you've already finished the race, you're not in control either
			ld	l,(ix+SP_CONTROL)
			ld	h,(ix+SP_CONTROL+1)	;Get control routine in HL
			ld	de,control_apply	;Return point
			push	de			;Set return point in stack
			jp	(hl)			;Jump to this player's control routine

cont_crashcontrol:	and	253			;Clear collision bit
			ld	e,a			;Store just in case
			ld	a,(ix+SP_COL_DUR)	;Get collision duration
			dec	a			;Decrease it
			ld	(ix+SP_COL_DUR),a	;Update collision duration
			jr	nz,cont_notyet		;No change in state if we're still in collision
			
			ld	(ix+SP_STATE),e		;No more crashed
			ld	(ix+SP_SPEED),a		;Stop car...
			call	direction_update	;Update direction
			jr	cont_wincontrol		;Keep slowing down

cont_notyet:		ld	a,(ix+SP_COL_DIR)	;Check collision direction
			rra				;First bit
			jr	c,cont_rotright	
			call	inc2frame		;Rotate left if direction bit was 0
			jr	cont_wincontrol
cont_rotright:		call	dec2frame		;Rotate right if direction bit was 1
cont_wincontrol:	ld	a,(ix+SP_SPEED)		;Get speed
			and	a
			ret	z			;Return if already 0
			dec	a			;Decresase it
			ld	(ix+SP_SPEED),a		;Update speed
			ret

;*************
;control_play: Control of all cars when replaying the race.
;*************
control_play:   	call    rec_getbit
			pop	bc			;No control_apply
                	ld      a,(ix+SP_LASTCONTROL)
                	ld      c,a
                	jp      nc,control_apply2	;If bit read is 0, use the same control as last time
                	call    rec_get4bits		;Otherwise, take 4 new bits from the recording stream and use them
                	jp      control_apply3

;***************
;control_clever: The most intelligent control routine. It looks ahead for grass, and uses all directions (22.5 precision instead of 45)
;***************
control_clever:		ld	l,(ix+SP_NEXTCHECK)
			ld	h,mapa_checks/256
			ld	a,(hl)		;Get left part of next checkpoint
			inc	l
			add	a,(hl)		;Add right
			rra			;Middle part
			sub	(ix+SP_MAPX)	;Check distance with car's current position
			ld	d,0		;D = 0 -> center, zero distance
			jr	z,clev_nohoriz	
			ld	d,1		;D = 1 -> left, positive distance
			jr	nc,clev_horiz
			ld	d,2		;D = 2 -> right, negative distance
			neg			;Absolute distance value
clev_horiz:		cp	32
			jr	c,clev_nohoriz
						;If distant is too high (>32), then it's the opposite direction
			ld	b,a		;Keep distance
			ld	a,d
			xor	3
			ld	d,a		;Reverse direction
			ld	a,64
			sub	b		;Adjust real distance = 64-dist
clev_nohoriz:		ld	b,a		;B = absolute distance X
						;Now let's repeat the same with vertical
			inc	l
			ld	a,(hl)		;Get up part of next checkpoint
			inc	l
			add	a,(hl)		;Add down
			rra			;Middle
			sub	(ix+SP_MAPY)	;Distance
			ld	e,0		;E = 0 -> center, zero distance
			jr	z,clev_novert	
			ld	e,6		;E = 6 -> up, positive distance
			jr	nc,clev_vert
			ld	e,3		;E = 3 -> down, negative distance
			neg			;positive
clev_vert:		cp	32
			jr	c,clev_novert
						;If distant is too high (>32), then it's the opposite direction
			ld	c,a
			ld	a,e
			xor	5		
			ld	e,a		;Reverse direction
			ld	a,64
			sub	c		;Adjust real distance = 64-dist
clev_novert:		ld	c,a		;C = absolute distance Y
			ld	hl,dirprefered-1
			ld	a,l
			add	a,d		;Add horizontal direction
			add	a,e		;Add vertical direction, clear carry
			ld	l,a
			ld	a,(hl)		;Get preprocessed prefered direction
			rra			;Get bit 0 of preprocessed prefered direction. 0 if diagonal, 1 if straight
			ld	l,a		;keep the rotated prefered direction in L
			jr	c,clev_recta	;Jump if straight direction

			rra			;Get bit 0 (used to be bit 1) of prefered direction.
			ld	l,a		;keep the rotated prefered direction in L
			jr	c,clev_diagalt
						
			ld	a,c		;bit was 0, that means signs of horizontal and vertical are different
			cp	b		;Compare Y distance to X distance
			jr	clev_cont1

clev_diagalt:		ld	a,b		;bit was 1, that means signs of horizontal and vertical are the same
			cp	c		;Compare X distance to Y distance
clev_cont1:		jr	z,clev_recta	;If they're the same, it's pure diagonal movement
						;  in other case, one of the directions has a bigger importance, so adjust
						;  and go for the 22.5 rotation frame that's needed
			jr	c,clev_decl
			inc	l		;Adjust diagonal direction to go for the dominant direction
			jr	clev_recta
clev_decl:		dec	l		;Adjust diagonal direction to go for the dominant direction
clev_recta:		ld	a,l
			ld	(prefdir),a	;Store definitive prefered direction
			ld	h,0
			ld	de,speeds
			add	hl,de		;HL=speeds (current prefered direction)

			call	checkgrass		;Look ahead in prefered direction
			jr	nz,clev_passnow		;If there's no grass, go for it
			call	checkgrass		;Look ahead turning 22.5 to the right from prefered direction
			jr	nz,clev_passright	;If there's no grass, go for it
			dec	l
			dec	l
			dec	l
			call	checkgrass		;Look ahead turning 22.5 to the left from prefered direction
			jr	nz,clev_passleft	;If there's no grass, go for it

			ld	c,14			;Grass is everywhere, slow down!
			jr	clev_slowdown

clev_passright:		ld	a,(prefdir)
			inc	a
			and	15
			ld	(prefdir),a		;Adjust prefered direction to the right
clev_passnow:		ld	c,15			;Don't do anything default control (all 4 bits at 1)
clev_slowdown:		ld	a,(prefdir)
			ld	b,a			;Keep prefered direction in A
			ld	a,(ix+SP_FRAME)		;Get current frame
			and	a			;Clear carry flag
			rra				;Divide by 2
			sub	b			;Calculate difference between prefered and current direction
			jr	z,clev_straight		;if zero, we're already on track -> keep straight
			and	15			;Keep only the lower bits
			cp	8			;check difference
			jr	c,clev_turnleft		;below 8, turn left
			ld	c,11			;control: turn right (clear bit 2)
			jr	clev_straight
clev_turnleft:		ld	c,7			;control: turn left (clear bit 4)
clev_straight:		ld	a,c
			ld	e,15			;Desired speed = 15 (maximum)
			cp	15			;No movement?
			jr	z,clev_nomaxspeed	;If there's no movement, continue
			ld	e,10			;Desired speed = 10 when turning
			ld	a,c
			or	1
			ld	c,a			;Make sure bit 0 is set?
clev_nomaxspeed:	jp	cb_nomaxspeed		;Keep moving in control_blind routine

clev_passleft:		ld	a,(prefdir)
			dec	a
			and	15
			ld	(prefdir),a		;Adjust prefered direction to the left
			jp	clev_passnow

;***************
;control_varied: control routine for all CPUs, it chooses another control routine depending on a random value and the constants set by the difficult level
;***************
control_varied:		ld	a,r
			and	127			;Take 7 bits
			cp	(ix+SP_IARAND1)	
			jp	nc,control_blind	;If the value read is below IARAND1, use the blind routine 1
			cp	(ix+SP_IARAND2)
			jp	nc,control_rand2	;If the value read is below IARAND2, use the totally random routine
			cp	(ix+SP_IARAND3)
			jp	nc,control_clever	;If the value read is below IARAND3, use the clever routine
							;Otherwise, use the following blind routine 2

;***************
;control_blind2: another stupid control routine, is fine with any portion of the checkpoint, instead of going for the centre
;***************
control_blind2: 	ld	a,(ix+SP_STATE)		;Get state
			dec	a			;1? (over grass)
			jp	z,control_blind		;If we're over grass, use the control_blind function instead
			ld	l,(ix+SP_NEXTCHECK)	;Get next checkpoint address
			ld	h,mapa_checks/256
			ld	a,(ix+SP_MAPX)		;Get current X position
			cp	(hl)			;Compare to left part of checkpoint
			inc	hl			;point to right part, without touching the flags
			ld	e,64			;64 for right
			jr	c,cb2_horizpassedka	;If carry, it seems like we need to go right, go to check distance
			ld	e,0			;0 for center
			jr	z,cb2_horizpassed	;If zero, horizontal is done 
			cp	(hl)			;Compare to the right part of checkpoint
			jr	z,cb2_horizpassed
			jr	c,cb2_horizpassed	;If zero or below, horizontal is done 
							;Seems to be left
			ld	e,32			;32 for left
			sub	(hl)
			cp	32			;Check if distance is over 32
			jr	nc,cb2_horizreverse	;Reverse if distance is over 32
			jr	cb2_horizpassed	
			
cb2_horizpassedka:	sub	(hl)
			add	a,32			;Check if distance is over 32
			jr	c,cb2_horizpassed	;No -> horizontal value is ok
cb2_horizreverse:	ld	a,e
			xor	96			;Reverse left<->right
			ld	e,a
cb2_horizpassed:	inc	l			;Point to up part
			ld	a,(ix+SP_MAPY)		;Get current Y position
			cp	(hl)			;Compare to the up part of checkpoint
			inc	hl			;Point to down part, without touching the flags
			ld	d,192			;192 for down
			jr	c,cb2_vertpassedka	;If carry, it seems like we need to go down, go to check distance
			ld	d,0			;0 for center
			jr	z,cb2_vertpassed	;If zero, vertical is done 
			cp	(hl)			;Compare to the down part of checkpoint
			jr	z,cb2_vertpassed
			jr	c,cb2_vertpassed	;If zero or below, horizontal is done 
							;Seems to be up
			ld	d,96			;96 for up
			sub	(hl)
			cp	32			;Check if distance is over 32
			jr	nc,cb2_vertreverse	;Reverse if distance is over 32
			jr	cb2_vertpassed
cb2_vertpassedka:	sub	(hl)
			add	a,32			;Check if distance is over 32
			jr	c,cb2_vertpassed
cb2_vertreverse:	ld	a,d
			xor	160			;Reverse up<->down
			ld	d,a
cb2_vertpassed:		ld	a,d			;Get vertical component
			add	a,e			;Add horizontal constant
			jp 	cb_novert2		;Go to look up the control in the table in control_blind function

;**************
;control_blind: stupid control routine, goes blindly to the center of the next checkpoint
;**************
control_blind:  	ld	l,(ix+SP_NEXTCHECK)	;Get next checkpoint address
			ld	h,mapa_checks/256
			ld	a,(hl)			;Get left part of checkpoint
			inc	l
			add	a,(hl)			;Add right part
			rra				;Medium
			sub	(ix+SP_MAPX)		;Substract current position
			jr	z,cb_nohoriz		;if zero, we're there, 0 for center
			jr	c,cb_noright		;If carry, we must probably go left
							; no carry, we must probably go right
			cp	32			;difference over 32?
			jr	nc,cb_yesleft		;Yes: so it's left instead
							; No: it's indeed right
cb_yesright:		ld	a,64			;64 for right
			jr	cb_nohoriz		;Horizontal calculation done

cb_noright:		add	a,32			;difference over 32?
			jr	nc,cb_yesright		;Yes: so it's right instead
							; No: it's indeed left
cb_yesleft:		ld	a,32			;32 for left

cb_nohoriz:		ld	e,a			;Keep horizontal constant in E register
			inc	l			
			ld	a,(hl)			;Get up part of checkpoint
			inc	l
			add	a,(hl)			;Add down part
			rra				;Medium
			sub	(ix+SP_MAPY)		;Substract current position
			jr	z,cb_novert		;if zero, we're there, 0 for center
			jr	c,cb_nodown		;If carry, we must probably go up
							; no carry, we must probably go down
			cp	32			;difference over 32?
			jr	nc,cb_yesup		;Yes: so it's up instead
							; No: it's indeed down
cb_yesdown:		ld	a,192			;192 for down
			jr	cb_novert
cb_nodown:		add	a,32			;difference over 32?
			jr	nc,cb_yesdown		;Yes: so it's down instead
							; No: it's indeed up
cb_yesup:		ld	a,96			;96 for up
cb_novert:		add	a,e			;Add horizontal constant
cb_novert2:		add	a,(ix+SP_FRAME)		;Add current frame
			rra				;Divide by 2
			ld	l,a			;and we get the lookup table address
			ld	h,tablagiros/256	;complete address
			ld	a,(hl)			;Get control from table
			ld	e,10			;Desired speed: 10
			cp	15			;No movement?
			ld	c,a
			jr	nz,cb_nomaxspeed	;If there was no movement
			ld	e,15
cb_nomaxspeed:		ld	a,(ix+SP_SPEED)		;Get speed
			cp	e			;Compare to desired speed
			ret	z			;Return if we're already there
			jr	nc,cb_speeddown		;If we're over desired speed, slow down (set bit 0 of control to 0, decreasing once)
							;Otherwise, accelerate (set bit 1 of control to 0, decreasing twice)
			dec	c
cb_speeddown:		dec	c
			ret

;**************
;control_apply: Move the cars depending on the value given by the control routine in register C
;**************
control_apply:  	ld      a,c
                	cp      (ix+SP_LASTCONTROL)	;Compare to last control value
                	jr      nz,contap_recordit
                	call    setrec0			;If it's equal, insert a 0 in the recording stream
                	jr      control_apply2		;Then apply it
contap_recordit:	call    setrec1			;If it's different, insert a 1 in the recording stream
                	call    setrec4bits		;And then store the control bits themselves
control_apply3: 	ld      (ix+SP_LASTCONTROL),c	;Store new last control
control_apply2:		ld	a,(ix+SP_SPEED)		;Get speed
			and	a
			ld	e,a
			ld	d,0
			ld	hl,girospeeds
			add	hl,de			;HL points to rotation resistance (depends on speed)
			bit	3,c			;Check Right
			jr	nz,norotateright
			ld	a,(ix+SP_SUBGIRO)
			sub	(hl)			;Check resistance to rotation
			ld	(ix+SP_SUBGIRO),a	;Update turning state
			jr	c,norotateleft		;If there's carry, there's no rotation
			call	dec2frame		;Decrease frame by 2 units
			call	direction_update	;Update direction
			jr	norotateleft
norotateright:		bit	2,c			;Check Left
			jr	nz,norotateleft
			ld	a,(ix+SP_SUBGIRO)
			sub	(hl)			;Check resistance to rotation
			ld	(ix+SP_SUBGIRO),a	;Update turning state
			jr	c,norotateleft		;If there's carry, there's no rotation
			call	inc2frame		;Increase frame by 2 units
			call	direction_update	;Update direction
norotateleft:		bit	0,c			;Check Down
			jr	nz,nospeeddown
			ld	a,(ix+SP_SPEED)		;Get speed
			and	a			;Already zero?
			jr	z,nospeeddown
			dec	a			;No > decrease it
			ld	(ix+SP_SPEED),a		;     and keep it
nospeeddown:		bit	1,c			;Check Up
                	ret	nz
                	ld	a,(ix+SP_SUBSPEED)	;Get subspeed value
                	add	a,(ix+SP_ACCELRATE)	;Try to accelerate
                	ld	(ix+SP_SUBSPEED),a	;Store subspeed value
                	ret	nc			;No carry, no accelaration
                	ld	a,(ix+SP_SPEED)		;Get speed
                	cp	15			;Already max speed?
                	ret	nc			;Yes > exit
                	inc	a			;No > increase it
                	ld	(ix+SP_SPEED),a		;     and keep it
control_dummy:		ret

;**************
;control_rand2: Control routine. Use 4 lower bits of random value read as control value.
;**************
;control_rand:		ld	a,r			;Get random value
control_rand2:		and	15			;Get 4 low bits
			ld	c,a			;Keep it in C
			ret				;Return
			;jp	control_apply

;**************
;scrollbg_down: Scroll the background up, so we're moving down
;**************
scrollbg_down:		ld	l,(iy+CAM_BUFFERPOS)
			ld	h,(iy+CAM_BUFFERPOS+1)	;Get bufferpos
			ld	de,-48
			add	hl,de			;One line up
			ld	a,(iy+CAM_INTRAY)	;Get INTRAY
			dec	a			;Decrease it
			cp	-8			;Check if we've reached -8
			jr	nz,scrollbg_down_end
							;If we've reached -8, adjust MAPY
			ld	a,(iy+CAM_MAPY)		;Get MAPY
			inc	a			;Increase it
			and	63			;Keep it in 0-63 range
			ld	(iy+CAM_MAPY),a		;Update MAPY
			ld	de,384
			add	hl,de			;Adjust BUFFERPOS 8 lines down
			xor	a			;And reset INTRAY
scrollbg_down_end:	ld	(iy+CAM_INTRAY),a	;Update INTRAY
			ld	(iy+CAM_BUFFERPOS),l
			ld	(iy+CAM_BUFFERPOS+1),h	;Update BUFFERPOS
			ret

;************
;scrollbg_up: Scroll the background down, so we're moving up
;************
scrollbg_up:		ld	l,(iy+CAM_BUFFERPOS)
			ld	h,(iy+CAM_BUFFERPOS+1)	;Get bufferpos
			ld	de,48
			add	hl,de			;One line down
			ld	a,(iy+CAM_INTRAY)	;Get INTRAY
			inc	a			;Increase it
			cp	1			;Check if we've reached 1
			jr	nz,scrollbg_up_end
							;If we've reached 1, adjust MAPY
			ld	a,(iy+CAM_MAPY)		;Get MAPY
			dec	a			;Decrease it
			and	63			;Keep it in 0-63 range
			ld	(iy+CAM_MAPY),a		;Update MAPY
			ld	de,-384
			add	hl,de			;Adjust BUFFERPOS 8 lines up
			ld	a,-7			;And reset INTRAY to -7
scrollbg_up_end:	ld	(iy+CAM_INTRAY),a	;Update INTRAY
			ld	(iy+CAM_BUFFERPOS),l
			ld	(iy+CAM_BUFFERPOS+1),h	;Update BUFFERPOS
			ret

;***************
;scrollbg_right: Scroll the background left, so we're moving right
;***************
scrollbg_right:		ld	l,(iy+CAM_BUFFERPOS)
			ld	h,(iy+CAM_BUFFERPOS+1)	;Get bufferpos
			ld	de,-3
			add	hl,de			;One char left
			ld	a,(iy+CAM_INTRAX)	;Get INTRAX
			dec	a			;Decrease it
			cp	-8			;Check if we've reached -8
			jr	nz,scrollbg_right_end
							;If we've reached -8, adjust MAPX
			ld	a,(iy+CAM_MAPX)		;Get MAPX
			inc	a			;Increase it
			and	63			;Keep it in 0-63 range
			ld	(iy+CAM_MAPX),a		;Update MAPX
			ld	de,24
			add	hl,de			;Adjust BUFFERPOS 8 characters right
			xor	a			;And reset INTRAX
scrollbg_right_end:	ld	(iy+CAM_INTRAX),a	;Update INTRAX
			ld	(iy+CAM_BUFFERPOS),l
			ld	(iy+CAM_BUFFERPOS+1),h	;Update BUFFERPOS
			ret

;**************
;scrollbg_left: Scroll the background right, so we're moving left
;**************
scrollbg_left:		ld	l,(iy+CAM_BUFFERPOS)
			ld	h,(iy+CAM_BUFFERPOS+1)	;Get bufferpos
			ld	de,3
			add	hl,de			;One char right
			ld	a,(iy+CAM_INTRAX)	;Get INTRAX
			inc	a			;Increase it
			cp	1			;Check if we've reached 1
			jr	nz,scrollbg_left_end
							;If we've reached 1, adjust MAPX
			ld	a,(iy+CAM_MAPX)		;Get MAPX
			dec	a			;Decrease it
			and	63			;Keep it in 0-63 range
			ld	(iy+CAM_MAPX),a		;Update MAPX
			ld	de,-24
			add	hl,de			;Adjust BUFFERPOS 8 characters left
			ld	a,-7			;And reset INTRAX to -7
scrollbg_left_end:	ld	(iy+CAM_INTRAX),a	;Update INTRAX
			ld	(iy+CAM_BUFFERPOS),l
			ld	(iy+CAM_BUFFERPOS+1),h	;Update BUFFERPOS
			ret

;**************
;camerapanning: Change the camera position so the car we are pointing to gets nearer to the desired position, depending on its direction.
;**************
camerapanning:		ld	a,(ix+SP_FRAME)
			and	254			;Clear bit 0 from the frame
			ld	c,a
			ld	b,0
			ld	hl,position_wanted
			add	hl,bc			;HL = points to position_wanted
			ld	a,(hl)			;Get horizontal desired position
			inc	hl
			push	hl
			cp	(iy+CAM_POSX)		;Compare to current position
			jr	z,cam_nohorizontal	;If zero, no need to change
			jr	c,cam_left		;If carry, move left
			call	scrollbg_left		;Scroll background left to move right
			inc	(iy+CAM_POSX)		;Increase cam position
cam_nohorizontal:	pop	hl
			ld	a,(hl)			;Get vertical desired position
			cp	(iy+CAM_POSY)		;Compare to current position
			jr	z,cam_novertical	;If zero, no need to change
			jr	c,cam_up		;If carry, move up
			call	scrollbg_up		;Scroll background up to move down
			inc	(iy+CAM_POSY)		;Increase cam position
cam_novertical: 	ret
cam_left:		call	scrollbg_right		;Scroll background right to move left
			dec	(iy+CAM_POSX)		;Decrease cam position
			jp	cam_nohorizontal
cam_up:			call	scrollbg_down		;Scroll background down to move up
			dec	(iy+CAM_POSY)		;Decrease cam position
			jp	cam_novertical

;***************
;movecar_scroll: Update the car position, and scroll the background if necessary
;***************
;IX=car pointer
;IY=camera pointer
movecar_scroll:		ld	b,(ix+SP_SPEED)		;Use speed as a counter
			ld	a,b
			and	a
			ret	z			;Return if speed is 0
			push	bc			;Keep counter for vertical movement
			ld	a,(ix+SP_DIRY)		;Get vertical speed direction
			and	a			;Check sign
			ld	h,a
			ld	a,(ix+SP_SUBY)		;Get vertical subspeed variable
			jp	m,msc_up
msc_down:		add	a,h			;Add speed to subspeed variable
			jr	nc,msc_down_no		;No carry means no movement
			ld	c,a			;Keep subspeed
			push	hl
			push	bc
			call	incy			;Move down
			call	scrollbg_down		;Scroll down
			pop	bc
			pop	hl
			ld	a,c			;Restore subspeed
msc_down_no:		djnz	msc_down		;Do it B times
			jp	msc_horiz		;Then go to horizontal movement
msc_up:			add	a,h			;Add speed to subspeed variable
			jr	c,msc_up_no		;No carry means no movement
			ld	c,a			;Keep subspeed
			push	hl
			push	bc
			call	decy			;Move up
			call	scrollbg_up		;Scroll up
			pop	bc
			pop	hl
			ld	a,c			;Restore subspeed
msc_up_no:		djnz	msc_up			;Do it B times
msc_horiz:		ld	(ix+SP_SUBY),a		;Store final vertical subspeed
			pop	bc			;Restore counter
			
			ld	a,(ix+SP_DIRX)		;Do the same for horizontal speed
			and	a
			ld	h,a
			ld	a,(ix+SP_SUBX)
			jp	m,msc_left
msc_right:		add	a,h
			jr	nc,msc_right_no
			ld	c,a
			push	hl
			push	bc
			call	incx
			call	scrollbg_right
			pop	bc
			pop	hl
			ld	a,c
msc_right_no:		djnz	msc_right
			jp	msc_end
msc_left:		add	a,h
			jr	c,msc_left_no
			ld	c,a
			push	hl
			push	bc
			call	decx
			call	scrollbg_left
			pop	bc
			pop	hl
			ld	a,c
msc_left_no:		djnz	msc_left
msc_end:		ld	(ix+SP_SUBX),a
			ret

;********
;movecar: Just update the car position
;********
;IX=car pointer
movecar:		ld	a,(ix+SP_SPEED)
			and	a
			ret	z			;Return if speed is 0
			ld	b,a			;Use speed as a counter
			push	bc			;Keep counter for vertical movement
			ld	a,(ix+SP_DIRY)		;Get vertical speed direction
			and	a			;Check sign
			ld	h,a
			ld	a,(ix+SP_SUBY)		;Get vertical subspeed variable
			jp	m,move_up
move_down:		add	a,h			;Add speed to subspeed variable
			jr	nc,move_down_no		;No carry means no movement
			ld	c,a			;Keep subspeed
			call	incy			;Move down
			ld	a,c			;Restore subspeed
move_down_no:		djnz	move_down		;Do it B times
			jp	move_horiz		;Then go to horizontal movement

move_up:		add	a,h			;Add speed to subspeed variable
			jr	c,move_up_no		;No carry means no movement
			ld	c,a			;Keep subspeed
			call	decy			;Move up
			ld	a,c			;Restore subspeed
move_up_no:		djnz	move_up			;Do it B times

move_horiz:		ld	(ix+SP_SUBY),a		;Store final vertical subspeed
			pop	bc			;Restore counter

			ld	a,(ix+SP_DIRX)		;Do the same for horizontal speed
			and	a
			ld	h,a
			ld	a,(ix+SP_SUBX)
			jp	m,move_left
move_right:		add	a,h
			jr	nc,move_right_no
			ld	c,a
			call	incx
			ld	a,c
move_right_no:		djnz	move_right
			jp	move_end
move_left:		add	a,h
			jr	c,move_left_no
			ld	c,a
			call	decx
			ld	a,c
move_left_no:		djnz	move_left
move_end:		ld	(ix+SP_SUBX),a
			ret

;***********
;volcarmapa: Dump 9 tiles addresses from the map to the buffer of the camera pointed by IY
;***********
volcarmapa:		ld	c,3		;3 rows
			ld	a,(iy+CAM_MAPY)	;Get Y map position
			ld	e,0
			and	a		;Clear carry flag
			rra
			rr	e		;Rotate AE a bit to right
			rra
			rr	e		;Rotate AE another bit to right
			ld	d,a		;DE = MAPY*64
			ld	a,(iy+CAM_MAPX)
			add	a,e		
			ld	e,a		;DE = (MAPY*64)+MAPX
			ld	hl,mapa
			add	hl,de		;HL = map position of upper left corner
			push	iy
			pop	ix		;IX = position in tilelist
vm_outerloop:		ld	b,3		;3 columns
			push	hl		;Keep position
vm_innerloop:		ld	a,(hl)		;Get value
			and	63		;Remove limit bits
			add	a,a		;Duplicate
			ld	e,a
			ld	d,tilelist/256
			ld	a,(de)		;Read first byte of tile address
			ld	(ix),a		;Write to camera buffer
			inc	ix
			inc	de
			ld	a,(de)		;Read second byte of tile address
			ld	(ix),a		;Write to camera buffer
			inc	ix
			ld	de,1		;Default increase for next column in the map
			bit	6,(hl)		;Check if we've reached the horizontal limit
			jr	z,vm_nowraphor
			ld	de,-63		;Wraparound increase for next column
vm_nowraphor:		add	hl,de		;Update map
			djnz	vm_innerloop	;Inner loop
			pop	hl		;Restore position
			ld	de,64		;Default increase for next row in the map
			bit	7,(hl)		;Check if we've reached the vertical limit
			jr	z,vm_nowrapver
			ld	de,-4032	;Wraparound increase for next row
vm_nowrapver:		add	hl,de		;Point to next row
			dec	c
			jr	nz,vm_outerloop	;Repeat for all rows
			ret

;*****************
;direction_update: Update the direction our car is looking to, changing the base speed depending on current frame
;*****************
direction_update:	ld	a,(ix+SP_FRAME)
			srl	a
			ld	e,a
			ld	d,0		;DE = frame/2 (==direction)
			ld	hl,speeds
			add	hl,de		;HL points to vertical speed
			ld	a,(hl)
			ld	(ix+SP_DIRY),a	;Set vertical direction
			ld	a,l
			sub	4		;Horizontal is 4 bytes away in the table
			ld	l,a
			ld	a,(hl)		
			ld	(ix+SP_DIRX),a	;Set horizontal direction
			ret

;**************
;get_attr_self: Get the attribute under your car
;**************
get_attr_self:		ld	e,1
			ld	l,e		;Both displazements are 1, to point the center of your car

;*********
;get_attr: Get the attribute at current vertical position+register E, current horizontal position+register L
;*********
get_attr:		ld	b,(ix+SP_MAPY)		;Get MAPY and INTRAY coordinates
			ld	a,(ix+SP_INTRAY)
			add	a,e			;Adjust position with displacement
			jp	m,ga_negy
ga_incy:		cp	8
			jr	c,ga_noincy
			inc	b			;IF INTRAY is over 8, adjust with MAPY until it's below 8
			sub	8			
			jr	ga_incy
ga_negy:		dec	b			;If INTRAY becomes negative, adjust with MAPY until it's positive
			add	a,8
			jp	m,ga_negy		
ga_noincy:		ld	(ga_intrayhere+1),a	;Store INTRAY
			ld	a,b
			and	63			;Wraparound map if necessary
			ld	e,0
			rra
			rr	e
			rra
			rr	e
			ld	d,a			;DE = resulting MAPY * 64
			ld	b,(ix+SP_MAPX)		;Now do the same with MAPX and INTRAX
			ld	a,(ix+SP_INTRAX)
			add	a,l
			jp	m,ga_negx
ga_incx:		cp	8
			jr	c,ga_noincx
			inc	b
			sub	8
			jr	ga_incx
ga_negx:		dec	b
			add	a,8
			jp	m,ga_negx
ga_noincx:		ld	(ga_intraxhere+1),a	;Store INTRAX
			ld	a,b
			and	63
			add	a,e
			ld	e,a			;DE=MAPY*64+MAPX
			ld	hl,mapa
			add	hl,de			;HL=map position
			ld	a,(hl)			;A = tilenumber
			and	63			;remove higher bits
			add	a,a			;Duplicate
			ld	e,a
			ld	d,tilelist/256		;DE points to tile
			ld	a,(de)
			ld	l,a
			inc	e
			ld	a,(de)
			ld	h,a			;HL= tile position, at (0,0)

ga_intrayhere:		ld	a,0			;Get vertical value
			rla
			rla
			rla				;8*vertical
ga_intraxhere:		add	a,0			;plus horizontal
			ld	e,a
			add	a,a
			add	a,e			;Multiply by 3
		
			ld	e,a
			ld	d,0
			add	hl,de			;HL=attribute position
			ld	a,(hl)			;A=attribute
			ret

;************
;velocimetro: Display the speedometer, and set sound parameters if necessary
;************
velocimetro:		ld	c,(iy+CAM_MESSLAP)
			ld	b,(iy+CAM_MESSLAP+1)
			call	printmessage		;Print number of laps
			ld	a,(iy+CAM_MARCADORGR)
			or	164
			ld	e,a
			ld	d,(iy+CAM_MARCADORGR+1)	;Get speedometer start address
			ld	hl,velo_sinaguja_up	;First restore the whole speedometer without any needle
			call	putchar_down		;Put character bytes from up to down
			inc	e			;Next screen position
			call	putchar_up		;Put character bytes from down to up
			ld	a,e
			add	a,30
			ld	e,a			;Point to next line minus 2 chars
			call	putchar_down		;Put character bytes from up to down
			inc	e			;Next screen position
			call	putchar_up		;Put character bytes from down to up
			inc	e			;Next screen position
			call	putchar_down		;Put character bytes from up to down
			inc	e			;Next screen position
			call	putchar_up		;Put character bytes from down to up
							;At this point, speedometer has no needle
			ld	h,velocidad/256		;Points to velocidad

			ld	a,(current_sound)
			srl	a
			cp	(iy+CAM_ID)		;If the sounding car belongs to this camera
			jr	nz,veloc_nosetsnd
			ld	a,(ix+SP_STATE)
			ld	(snd_state+1),a		;Set sound state
			ld	a,(ix+SP_SPEED)
			ld	(snd_speed+1),a		;Set sound speed
veloc_nosetsnd:		ld	a,(ix+SP_SPEED)		;Get current speed
			add	a,a
			add	a,a
			add	a,a
			add	a,a			;Multiply by 16
			ld	l,a			;Keep needle characters address
			add	a,a			
			jr	c,vel_right		;If A was > 128, speed was over 8, so we're in the right part of the speedometer
							;left part of the speedometer
			add	a,a			
			jr	c,vel_leftup		;If A was > 64, we're on the upper part of the speedometer
							;vel_leftdown: we're in the low-left part
			dec	e
			dec	e			;Get 2 characters to the left of current one
vel_horiz:		call	putchar_down		;Put character bytes from up to down
			dec	e			;Now previous character
			jp	putchar_up		;Put character bytes from down to up, then exit

vel_right:		add	a,a
			jr	c,vel_horiz		;If A was > 192, speed was over 12, so we're in the right-down part of the speedometer

							;vel_rightup
vel_vert:		dec	e			;Decrease a character position
			call	putchar_down		;Put character bytes from up to down
			ld	a,e
			sub	32
			ld	e,a			;Point to upper char
			jp	putchar_up

vel_leftup:		dec	e			;Decrease a character position
			jp	vel_vert		;From now on, this is the same as right_up

;**********
;crearmapa: Create map, prepare all cars to start race
;**********
crearmapa:		ld	de,mapa
			call	deexo			;Uncompress map to mapa buffer
			ld	hl,mapa-1
			ld	de,64			;Lenght of a row
			ld	b,e			;Number of rows
cm_rightlimit:		add	hl,de
			ld	a,(hl)
			or	64
			ld	(hl),a			;Mark right limit
			djnz	cm_rightlimit		
			ld	b,64
cm_downlimit:		ld	a,(hl)
			or	128
			ld	(hl),a			;Mark low limit
			dec	l
			djnz	cm_downlimit
			ld	hl,mapa_checks
			ld	de,mapa_checks+256
			ld	bc,256
			ldir				;Copy the checkpoints
			dec	d
			ld	a,(de)
			rrca				;Divide by 2
			sub	130			;Adjust number
			ld	b,a			;Number of pair of values to enlarge
;			ld	l,1
cm_novicecheck:		inc	l
			ld	a,(hl)
			dec	a			;Decrease left/up limit
			jp	m,cm_nv_noleft		;If it becomes negative, don't touch it
			ld	(hl),a
cm_nv_noleft:		inc	l
			ld	a,(hl)
			inc	a			;Increase right/down limit
			cp	64
			jr	z,cm_nv_nodown		;If it becomes 64, don't touch it
			ld	(hl),a
cm_nv_nodown:		djnz	cm_novicecheck

			ld	a,(recording)		
			cp	2			;Check if we're replaying
			jr	nz,cm_nv_randomize
			ld	a,(startpositions_rec)	;Get the same random value that we got when we played
			jr	cm_nv_norand
cm_nv_randomize:	ld	a,r			;Get random value
			and	31			;Keep the 5 lower bits
			ld	(startpositions_rec),a	;Store value for later replay
cm_nv_norand:		ld	h,startpositions/256
			ld	l,a
			ld	a,(hl)			;Take random start positions
			ld	l,a
			ld	a,(de)			;Get start of positions
;			ld	e,a
			ld	h,a
			ld	ix,car1			;First car
			ld	b,4			;Number of cars
cm_set_car:		push	bc
			ld	e,h			;E = start of positions
			rr	l			
			jr	c,cm_nojump1
			inc	e			;Increase position if first bit is 0
cm_nojump1:		rr	l
			jr	c,cm_nojump2
			inc	e			;Increase position twice if second bit is 0
			inc	e			
cm_nojump2:		push	hl
			ld	a,(de)			;Get mapx for this car
			ld	(ix+SP_MAPX),a		;Set it
			ld	a,4
			add	a,e
			ld	e,a			;Point to next data
			ld	a,(de)			;Get mapy for this car
			ld	(ix+SP_MAPY),a		;Set it
			ld	a,4
			add	a,e
			ld	e,a			;Point to next data
			ld	a,(de)			;Get intrax for this car
			ld	(ix+SP_INTRAX),a	;Set it
			ld	a,4
			add	a,e
			ld	e,a			;Point to next data
			ld	a,(de)			;Get intray for this car
			ld	(ix+SP_INTRAY),a	;Set it
			ld	a,4
			add	a,e
			ld	e,a			;Point to next data
			ld	a,(de)			;Get frame for this car
			ld	(ix+SP_FRAME),a		;Set it

			inc	a			;Increase it
			ld	hl,Car333-27		;Graphic address - 1 frame
			ld	bc,27			;Each frame has 3x3x3 bytes
cm_set_frame:		add	hl,bc	
			dec	a
			jr	nz,cm_set_frame		;Get graphic address in HL
                	ld      (ix+SP_LASTCONTROL),c	;Last control=27 (impossible value, will force to set it the first time)
			ld	(ix+SP_SUBX),a		;Reset a bunch of variables
			ld	(ix+SP_SUBY),a		
			ld	(ix+SP_GRAPH),l
			ld	(ix+SP_GRAPH+1),h	;Set graphic address
			ld	(ix+SP_SPEED),a
			ld	(ix+SP_SUBSPEED),a
			ld	(ix+SP_SUBGIRO),a
			ld	(ix+SP_MINIMAPX),a
			ld	(ix+SP_MINIMAPY),a
			ld	(ix+SP_LAPS),a
			ld	(ix+SP_COL_DUR),a
			ld	(ix+SP_COL_DIR),a
			ld	(ix+SP_MAPPOINTS),a
			ld	(ix+SP_BESTLAP),a
			ld	(ix+SP_BESTLAP+1),a
			ld	(ix+SP_LAPSTART),a
			ld	(ix+SP_LAPSTART+1),a
			ld	(ix+SP_TIMESTAMP),a
			ld	(ix+SP_TIMESTAMP+1),a
			ld	(ix+SP_TIMESTAMPLAP),a
			ld	(ix+SP_TIMESTAMPCP),a
			inc	a
			ld	(ix+SP_NEXTCHECK),a	;First check at 1
			ld	a,(ix+SP_STATE)		;Get state
			and	144			;Preserve important bits (human & playing)
			ld	(ix+SP_STATE),a		;Update state
			ld	a,(ix+SP_CAMERA)
			ld	iy,camera_left
			cp	(iy+CAM_CAR)		;Car is pointed by the left camera?
			jr	z,dosetcamera		
			ld	iy,camera_right
			cp	(iy+CAM_CAR)		;Car is pointed by the right camera?
dosetcamera:		call	z,setcamera		;If a car is pointed by a camera, set this camera too
			push	de
			call	direction_update	;Update direction according to frame
			pop	de
			ld	bc,car2-car1
			add	ix,bc			;Point to next car
			pop	hl
			pop	bc
			dec	b
			jp	nz,cm_set_car		;Loop for all cars
			ret

;**********
;switchcar: Switch the car on a certain camera, avoiding the repetition of the same car in both cameras
;**********
switchcar:		ld	ix,car1			;First car
			ld	a,(other)		;The car of the other camera
			ld	b,a
			ld	a,(iy+CAM_CAR)		;Get current car
switch_next:		inc	a			;Increase it
			and	3			;Keep it in 0-3 range
			cp	b			;Compare with the one from the other camera
			jr	z,switch_next		;If it's the same, try another
			ld	(iy+CAM_CAR),a		;Set new car in the camera
			and	a
			jr	z,setcamera
			ld	b,a			;If it's not the first car
			ld	de,car2-car1
switch_add:		add	ix,de			;Update IX with the proper car
			djnz	switch_add

;**********
;setcamera: Set the camera for a certain car
;**********
setcamera:		;ld	a,(ix+SP_STATE)
			;and	16
			bit	4,(ix+SP_STATE)		;Check if the car is racing
			jr	nz,switchcar		;No: keep switching car
			push	de			;Keep DE
			ld	a,(ix+SP_CAMERA)
			ld	(iy+CAM_CAR),a		;Set car identificator
			ld	b,6
			ld	(iy+CAM_POSX),b		
			ld	(iy+CAM_POSY),b		;Initially set car in the centre of the camera (relative to upper left corner) -> 6,6
			ld	d,(ix+SP_MAPX)		;Get car MAPX position
			ld	a,(ix+SP_INTRAX)	;And INTRAX position
			sub	b			;Calculate new INTRAX for the camera
			jr	nc,stc_nocarryx
			dec	d			;If it became out of bounds, adjust MAPX 
			add	a,8			; and adjust INTRAX
stc_nocarryx:		ld	b,a
			ld	(iy+CAM_MAPX),d		;Store MAPX for the cam
			xor	a
			sub	b			;Camera's INTRAX is in -7 to 0 range
			ld	(iy+CAM_INTRAX),a	;Store INTRAX for the cam
			ld	de,-3
			ld	hl,thebigbuffer		;Buffer position start
			and	a
			jr	z,stc_nosubstractx
stc_substractx:		add	hl,de			;Substract 1*3 until we've compensated all INTRAX
			djnz	stc_substractx

stc_nosubstractx:	ld	d,(ix+SP_MAPY)		;Now repeat the same for Y coordinate
			ld	a,(ix+SP_INTRAY)
			sub	6
			jr	nc,stc_nocarryy
			dec	d
			add	a,8
stc_nocarryy:		ld	b,a
			ld	(iy+CAM_MAPY),d
			xor	a
			sub	b
			ld	(iy+CAM_INTRAY),a
			ld	de,-48			;Substract 16*3 for vertical position adjust
			and	a
			jr	z,stc_nosubstracty
stc_substracty:		add	hl,de
			djnz	stc_substracty
stc_nosubstracty:	ld	(iy+CAM_BUFFERPOS),l
			ld	(iy+CAM_BUFFERPOS+1),h	;Store BUFFERPOS

			ld	b,6
stc_campan:		push	bc
			call	camerapanning		;Pan the camera to set the car to the desired position
			pop	bc
			djnz	stc_campan		;Do it 6 times, to make sure we reach the place
			ld	a,67
			xor	(ix+SP_COLOR)		;Get bright color
			add	a,a
			add	a,a
			add	a,a			;Move color to paper position
			ld	e,a			;Keep it in register E
			ld	c,4			;Number of rows
			ld	l,(iy+CAM_MARCADORAT)
			ld	h,(iy+CAM_MARCADORAT+1)	;Get marker attributes position for this camera
stc_marca_out:		ld	b,8			;8 characters
			ld	a,e			;Get color
stc_marca_in:		ld	(hl),a			;Store color
			inc	l			;Next character
			djnz	stc_marca_in		;Loop for all characters
			ld	a,24
			add	a,l
			ld	l,a			;Point to next line
			dec	c
			jr	nz,stc_marca_out	;Loop for all 4 rows
			pop	de			;Restore DE
			ret

;******
;pause: Pause the game, and offer the chance to abort
;******

pause:			call	wait_nokey		;Wait till no key is pressed
			ld	bc,mpause_pause
			call	printmessage		;Print pause message
			call	wait_key		;Wait for a key to be pressed
			halt				;Make sure we get the key registered
			ld	a,(key_g_a)		;Check semirow A-G
			and	1			;Check if key pressed is A
			ret	nz			;Exit from pause if it isn't

			call	wait_nokey		;Wait till no key is pressed
			ld	bc,mpause_abort
			call	printmessage		;Print the abort message
pause_abort:		call	wait_key		;Wait for a key to be pressed
			ld	a,(key_y_p)
			and	16
			jr	z,abort_tomenu		;Yes: Abort to Menu
			ld	a,(key_b_sp)
			and	8
			jr	z,pause			;No: Back to pause
			ld	a,(key_t_q)
			and	16
			jr	nz,pause_abort		;Not Y,N, or T -> keep waiting
							;Aborting track
			ld	a,(recording)		
			cp	2
			jr	z,notreallyaborting	;Aborting from a Replay doesn't count
			ld	(aborted),a		;Mark that we have aborted (so we don't have the right to see the special pictures)
notreallyaborting:	pop	hl			;Trash return address
			jp	end_stage		;Track: Abort this track

abort_tomenu:		ld	hl,end_stage_normal
			ld	(end_stage+1),hl	;Restore end_stage routine if we were replaying
			ld	a,(is128k)
			ld	(recording),a		;Restore recording variable if we were replaying
			pop	hl			;Trash return address
			call	silencia_ay		;Silence the AY chip 
			jp	menu			;Go to menu

;**************
;timeprint_car: Print the current lap time for the car, or the best lap time if it has arrived.
;**************
timeprint_car:		bit	2,(ix+SP_STATE)		;Has the car arrived?
			jr	z,tp_current
			ld	h,(ix+SP_BESTLAP)	;Yes: Get the best lap time
			ld	l,(ix+SP_BESTLAP+1)
			jr	timeprint		;     and print it
tp_current:		ld	hl,(main_ticks)		;Get current ticks
			ld	d,(ix+SP_LAPSTART)
			ld	e,(ix+SP_LAPSTART+1)	;Get lap start timestamp
			and	a
			sbc	hl,de			;Do the substraction

;**********			
;timeprint: Print the timestamp in HL into the camera pointed by IY
;**********
timeprint:		ld	a,15			;0 character minus 1
			ld	de,-6000		;First check the 10 minutes
tp_getnum3:		inc	a			;Increase char
			add	hl,de			;Substract 6000
			jr	c,tp_getnum3		;Keep doing it until we're under 0
			sbc	hl,de			;Add the last 6000 back, so we're over 0 again
			ld	(iy+CAM_NUMMINDEC),a	;Set first digit into the message
			ld	a,2			;Next, 0 character with semicolon minus 1
			ld	de,-600			;Next the minutes
tp_getnum2:		inc	a			;Increase char
			add	hl,de			;Substract 600
			jr	c,tp_getnum2		;Keep doing it until we're under 0
			sbc	hl,de			;Add the last 600 back, so we're over 0 again
			ld	(iy+CAM_NUMMINUNI),a	;Set second digit into the message
			ld	a,15			;Repeat the same process for 10 seconds
			ld	de,-100
tp_getnum1:		inc	a
			add	hl,de
			jr	c,tp_getnum1
			sbc	hl,de
			ld	(iy+CAM_NUMSEGDEC),a
			ld	a,15			;And finally for seconds too
			ld	e,-10
tp_getnum0:		inc	a
			add	hl,de
			jr	c,tp_getnum0
			ld	(iy+CAM_NUMSEGUNI),a
			ret				;No decimals!

;***********
;timeprint3: Print the timestamp in HL into mes_mt_m10 message, with decimals. If the first cipher is a 0, put a space.
;***********
timeprint3:		and	a
			ld	a,15			;character 0 minus 1
			ld	bc,-6000		;10 minutes
tp3_getnum3:		inc	a			;Increase char
			add	hl,bc			;Substract until we're under 0
			jr	c,tp3_getnum3
			sbc	hl,bc			;Restore last
			cp	16
			jr	nz,tp3_firstone
			ld	a,CHR_SPACE		;Replace 0 with a space
tp3_firstone:		ld	(mes_mt_m10),a		;Set char
			jr	tp3_getnum2		;Next cipher

;***********
;timeprint2: Print the timestamp in HL into mes_mt_m10 message, with decimals. If above 10 minutes, display '------', otherwise the first character will be the plus sign.
;***********
timeprint2:		ld	a,CHR_PLUS
			ld	(mes_mt_m10),a		;Set plus sign for first char
			ld	bc,6000
			and	a			;No carry
			sbc	hl,bc			;Substract 6000
			jr	nc,tp2_toomuch		;If it's too much, jump
			add	hl,bc			;Restore time
tp3_getnum2:		ld	a,2			;0 character with semicolon minus 1
			ld	bc,-600			;1 minute
tp2_getnum2:		inc	a			;Increase character
			add	hl,bc
			jr	c,tp2_getnum2		;Do it until we're under 0
			sbc	hl,bc			;Restore las substraction
			ld	(mes_mt_m1),a		;Store minutes
			ld	a,15
			ld	bc,-100			;Repeat for 10 seconds
tp2_getnum1:		inc	a
			add	hl,bc
			jr	c,tp2_getnum1
			sbc	hl,bc
			ld	(mes_mt_s10),a		;Store tens of seconds
			ld	a,15
			ld	c,-10			;Repeat for 1 second
tp2_getnum0:		inc	a
			add	hl,bc
			jr	c,tp2_getnum0
			ld	(mes_mt_s1),a		;Store seconds
			ld	a,26			;Finally, the decimals.
			add	a,l			;Adjust character and add back the last 10 substracted.
			ld	(mes_mt_d),a
			ld	hl,mes_mt_m10		;HL points to message to be written
			ret
tp2_toomuch:		ld	hl,mes_mt_toomuch	;HL now points to "------" message
			ret

;**************
;printmicromap: Print the micromap addressed by A/4, in address DE of the screen
;**************
printmicromap:		add	a,a

;***************
;printmicromap2: Print the micromap addressed by A/2, in address DE of the screen
;***************
printmicromap2:		add	a,a
			ld	l,a
			ld	h,mapa/256	;HL points to the map
			ld	bc,128		;Number of bytes to write (4x4x8)
pmm_scan:		ldi
			ldi
			ldi
			ldi			;Write 4 bytes
			ret	po		;Exit condition: BC=0
			dec	hl
			ld	a,29
			add	a,l		;Point to next line in character
			ld	l,a
			jr	c,pmm_changechar
						;No need to change character
			inc	d		;Next position
			ld	a,253		;-3
			dec	de		;-1
			add	a,e
			ld	e,a		;Update DE
			jr	pmm_scan	;Next line

pmm_changechar:		inc	h		;Point to the chars below
			inc	d		;First line of the character
			dec	de		;-1
			ld	a,29		;+32, -3
			add	a,e		;Next line, first character
			ld	e,a		;Update DE
			jr	c,pmm_scan	;If there's carry, there has been a third change, no need to adjust: keep printing
			ld	a,d
			sub	8		;Adjust third
			ld	d,a
			jr	pmm_scan	;Keep printing

;*************
;attrblock4x4: set the attributes of a 4x4 chars block
;*************
attrblock4x4:		ld	b,4		;Number of lines
			jr	attrblock4x

;*************
;attrblock5x4: set the attributes of a 5x4 chars block
;*************
attrblock5x4:		ld	b,5		;Number of lines
						;A= attribute, DE = address to paint
attrblock4x:		ld	(de),a
			inc	e
			ld	(de),a
			inc	e
			ld	(de),a
			inc	e
			ld	(de),a		;All chars in a line painted
			inc	de
			ld	hl,28
			add	hl,de		;Go to next attribute line
			ex	de,hl		;Result in DE
			djnz	attrblock4x	;Keep looping
			ret

;***************
;updatepersdata: Update personalized championship data
;***************
updatepersdata:		ld	de,mpers_points1		;Message to be updated
			ld	hl,championships_data+32*3+11	;Data
			ld	b,13		;Number of bytes to be updated
updatper_loop:		ld	a,(hl)		;Get data
			add	a,CHR_0		;Add 0 character constant
			ld	(de),a		;Update message
			inc	hl		;Next data
			inc	de
			inc	de
			inc	de		;Next message position
			djnz	updatper_loop	;Do for all bytes
			ld	bc,mpers_param
			jp	printmessage	;Print message and return

;*******************
;putmiddlemicromaps: Print the micromaps in the middle of the championship personalization screen
;*******************

pmidmicro_error:	dec	l				;Point to previous track
			inc	a				
			ld	(hl),a				;Set 1 lap
			jr	pmidmicro_putattr		;Go back to painting loop

putmiddlemicromaps:	ld	b,8				;Number of maps
			ld	hl,championships_data+3*32+16	;Personalized data, number of laps of first track
			ld	de,22720			;Attributes, line 6

pmidmicro_putattr:	ld	a,(hl)				;Get number of laps for the current track
			inc	l				;Point to next track
			and	a				;Check if it's 0
			jr	z,pmidmicro_blackhere

			ld	a,5				;Non zero: Cyan color
			push	bc				;Keep registers
			push	de
			push	hl				
			call	attrblock5x4			;Paint cyan attributes for map and number of tracks
			pop	hl				;Restore registers
			pop	de
			pop	bc
			ld	a,e
			add	a,4				;Point to next position in attributes
			ld	e,a
			djnz	pmidmicro_putattr		;Do it for all tracks
			ld	a,8				;All maps!
			ld	(person_maps),a			;Set number of personal maps
			dec	e
			dec	e
			dec	e
			dec	e				;Point to last map
			ld	a,3				;Magenta
			push	hl
			call	attrblock4x4			;Selected map is magenta
			pop	hl
			jr	pmidmicro_continue		;Continue

pmidmicro_blackhere:	ld	a,8
			sub	b			;A = number of tracks
			jr	z,pmidmicro_error	;It shouldn't have a 0, minimum is 1, so fix it
			ld	(person_maps),a		;Keep it
			ld	a,27			;Magenta ink and paper, to clear stage
			push	bc
			push	de
			push	hl
			call	attrblock4x4		;Set a magenta block
			xor	a			;Black color
			ld	b,1			;Just 1 line
			call	attrblock4x		;Clear laps line
			pop	hl
			pop	de
			pop	bc
			dec	b			;Decrease counter
			jr	z,pmidmicro_continue	;If we were in the last map, no need to do anything else

pmidmicro_blackem:	ld	a,e
			add	a,4
			ld	e,a			;Point to next map attributes
			xor	a			;Black color
			push	bc
			push	de
			push	hl
			call	attrblock5x4		;Paint a 5x4 black block
			pop	hl
			pop	de
			pop	bc
			djnz	pmidmicro_blackem	;Do it for all remaining positions

pmidmicro_continue:	ld	de,16576		;Graphic position to start printing the tracks
			ld	l,(championships_data+3*32+24)%256	;Point to tracks*2
			ld	b,8			;8 tracks
pmidmicro_putmapsup:	push	bc
			ld	a,(hl)			;Get track number*2
			push	de
			push	hl
			call	printmicromap2		;Paint track
			pop	hl
			inc	l			;Point to next track number
			pop	de
			ld	a,e			
			add	a,4
			ld	e,a			;Point to next graphic position
			pop	bc
			djnz	pmidmicro_putmapsup	;Loop for all maps
			ret

;*******************
;getkey_personalize: Wait for keys ENTER or 0-9 to be pressed. If ENTER is pressed, exit with carry set, otherwise exit with the value of key in B
;*******************

getkey_personalize:	halt
			ld	a,(key_h_en)
			and	1
			scf		;Set carry flag
			ret	z	;ENTER
			ld	a,(key_5_1)
			ld	b,1
			rra
			ret	nc	;1
			inc	b
			rra
			ret	nc	;2
			inc	b
			rra
			ret	nc	;3
			inc	b
			rra
			ret	nc	;4
			inc	b
			rra
			ret	nc	;5
			ld	a,(key_6_0)
			ld	b,0
			rra
			ret	nc	;0
			ld	b,9
			rra
			ret	nc	;9
			dec	b
			rra
			ret	nc	;8
			dec	b
			rra
			ret	nc	;7
			dec	b
			rra
			jr	c,getkey_personalize
			ret		;6

;**************
;restorebright: restore the brightness in the minimap
;**************
restorebright:		ld	de,23048		;Minimap attribute address
restoringbright_out:	ld	b,8			;Number of columns
			ld	a,96			;Bright green color
restoringbright_in:	ld	(de),a			;Paint it
			inc	e			;Next position
			djnz	restoringbright_in	;Repeat for all chars
			ld	a,e
			add	a,24
			ld	e,a			;Point to next line
			jr	nc,restoringbright_out	;Repeat for all rows
			ret

;*********
;doreplay: Start replay of previous race
;*********
doreplay:		call	record_prepareplay	;Prepare the replay
			ld	hl,endreplay
			ld	(end_stage+1),hl	;Redirect end_stage routine
			jp	start_stage		;Start!

;*********
;wait_key: Wait until a key is pressed
;*********
wait_key:		call	check_key
			jr	z,wait_key
			ret

;****************
;(included code): Adapted CezBlocks routines
;****************
			INCLUDE	"code/cezhalfblocks48optflex.asm"

;***********
;(Messages): A pair of messages that didn't fit with the rest
;***********
message_presskey:	defb	32+64,6*32+17,128+7,5,CHR_P,CHR_R,CHR_E,CHR_S,CHR_S,32+64,7*32+18,128+7,5,CHR_A,CHR_SPACE,CHR_K,CHR_E,CHR_Y,127

message_clock:		defb	32+64,19
message_cl_m10:		defb	CHR_0
message_cl_m1:		defb	CHR_0_
message_cl_s10:		defb	CHR_0
message_cl_s1:		defb	CHR_0,127

;*****************
;(included stuff): Lots of things
;*****************
			INCLUDE "data/tablas.asm"	;Tables
			INCLUDE	"messages.asm"		;Messages
labelshere:
IF STEPN=1						;Conditional compilation
			INCLUDE "data/labels.asm"	;CezBlocks tiles & sprites
ELSE
			INCLUDE "labels.lst"		;Addresses of CezBlocks Tiles & sprites, needed to compile the second step
			push	bc
			ld	de,16384
			ld	hl,eggpacked
			call	deexo			;Unpack easter egg
			call	wait_nokey		;Wait for a nokey to be pressed
			call	micropause
			call	wait_key		;Press a key to exit
			pop	bc
			ret				;Return
eggpacked:		INCBIN	"bindata/egg.exp"	;Easter egg picture compressed
ENDIF
			ORG	0F5B1h
			INCLUDE "data/brujula.asm"	;compass graphics
			INCLUDE "data/data.asm"		;CezBlocks chars
mapa01:			INCBIN	"bindata/fase01.exp"	;Stage 1 (didn't fit with the others)
is128k:			defb	1			;Variable to know if we're in 128k mode
			INCLUDE "data/velocidad.asm"	;Speed marker graphics
ins_end:
